/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import java.io.IOException;

public class FirebaseRequestInitializer
implements HttpRequestInitializer {
    private final HttpCredentialsAdapter credentialsAdapter;
    private final int connectTimeout;
    private final int readTimeout;

    public FirebaseRequestInitializer(FirebaseApp app) {
        GoogleCredentials credentials = ImplFirebaseTrampolines.getCredentials(app);
        this.credentialsAdapter = new HttpCredentialsAdapter((Credentials)credentials);
        this.connectTimeout = app.getOptions().getConnectTimeout();
        this.readTimeout = app.getOptions().getReadTimeout();
    }

    public void initialize(HttpRequest httpRequest) throws IOException {
        this.credentialsAdapter.initialize(httpRequest);
        httpRequest.setConnectTimeout(this.connectTimeout);
        httpRequest.setReadTimeout(this.readTimeout);
    }
}

