/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import com.google.common.annotations.VisibleForTesting;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseAppLifecycleListener;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.internal.Base64Utils;
import com.google.firebase.internal.FirebaseAppStore;
import com.google.firebase.internal.GuardedBy;
import com.google.firebase.internal.IGetAccessToken;
import com.google.firebase.internal.Joiner;
import com.google.firebase.internal.Log;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.internal.Objects;
import com.google.firebase.internal.Preconditions;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.Tasks;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class FirebaseApp {
    private static final String LOG_TAG = "FirebaseApp";
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final String MEASUREMENT_CLASSNAME = "com.google.android.gms.measurement.AppMeasurement";
    private static final String AUTH_CLASSNAME = "com.google.firebase.auth.FirebaseAuth";
    private static final String IID_CLASSNAME = "com.google.firebase.iid.FirebaseInstanceId";
    private static final String CRASH_CLASSNAME = "com.google.firebase.crash.FirebaseCrash";
    private static final List<String> API_INITIALIZERS = Arrays.asList("com.google.firebase.auth.FirebaseAuth", "com.google.firebase.iid.FirebaseInstanceId");
    private static final List<String> DEFAULT_APP_API_INITITALIZERS = Collections.singletonList("com.google.firebase.crash.FirebaseCrash");
    private static final Set<String> CORE_CLASSES = Collections.emptySet();
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    static final Map<String, FirebaseApp> sInstances = new HashMap<String, FirebaseApp>();
    private final String mName;
    private final FirebaseOptions mOptions;
    private final AtomicBoolean mDeleted = new AtomicBoolean();
    private final List<AuthStateListener> mAuthStateListeners = new CopyOnWriteArrayList<AuthStateListener>();
    private final List<FirebaseAppLifecycleListener> mLifecycleListeners = new CopyOnWriteArrayList<FirebaseAppLifecycleListener>();
    private IGetAccessToken mGetAccessToken;

    IGetAccessToken getIGetAccessToken() {
        this.checkNotDeleted();
        return this.mGetAccessToken;
    }

    @NonNull
    public String getName() {
        this.checkNotDeleted();
        return this.mName;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.checkNotDeleted();
        return this.mOptions;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FirebaseApp)) {
            return false;
        }
        return this.mName.equals(((FirebaseApp)o).getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper(this).add("name", this.mName).add("options", this.mOptions).toString();
    }

    public static List<FirebaseApp> getApps() {
        return new ArrayList<FirebaseApp>(sInstances.values());
    }

    @Nullable
    public static FirebaseApp getInstance() {
        return FirebaseApp.getInstance(DEFAULT_APP_NAME);
    }

    public static FirebaseApp getInstance(@NonNull String name) {
        Object object = sLock;
        synchronized (object) {
            String availableAppNamesMessage;
            FirebaseApp firebaseApp = sInstances.get(FirebaseApp.normalize(name));
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> availableAppNames = FirebaseApp.getAllAppNames();
            if (availableAppNames.isEmpty()) {
                availableAppNamesMessage = "";
            } else {
                String string = String.valueOf(Joiner.on(", ").join(availableAppNames));
                availableAppNamesMessage = string.length() != 0 ? "Available app names: ".concat(string) : new String("Available app names: ");
            }
            String errorMessage = String.format("FirebaseApp with name %s doesn't exist. %s", name, availableAppNamesMessage);
            throw new IllegalStateException(errorMessage);
        }
    }

    public static FirebaseApp initializeApp(FirebaseOptions options) {
        return FirebaseApp.initializeApp(options, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseApp initializeApp(FirebaseOptions options, String name) {
        FirebaseApp firebaseApp;
        FirebaseAppStore appStore = FirebaseAppStore.initialize();
        String normalizedName = FirebaseApp.normalize(name);
        Object object = sLock;
        synchronized (object) {
            Preconditions.checkState(!sInstances.containsKey(normalizedName), new StringBuilder(33 + String.valueOf(normalizedName).length()).append("FirebaseApp name ").append(normalizedName).append(" already exists!").toString());
            firebaseApp = new FirebaseApp(normalizedName, options);
            sInstances.put(normalizedName, firebaseApp);
        }
        appStore.persistApp(firebaseApp);
        FirebaseApp.initializeApis(FirebaseApp.class, firebaseApp, API_INITIALIZERS);
        if (firebaseApp.isDefaultApp()) {
            FirebaseApp.initializeApis(FirebaseApp.class, firebaseApp, DEFAULT_APP_API_INITITALIZERS);
        }
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        boolean valueChanged = this.mDeleted.compareAndSet(false, true);
        if (!valueChanged) {
            return;
        }
        Object object = sLock;
        synchronized (object) {
            sInstances.remove(this.mName);
        }
        FirebaseAppStore appStore = FirebaseAppStore.getInstance();
        if (appStore != null) {
            appStore.removeApp(this.mName);
        }
        this.notifyOnAppDeleted();
    }

    private FirebaseApp(String name, FirebaseOptions options) {
        this.mName = Preconditions.checkNotEmpty(name);
        this.mOptions = Preconditions.checkNotNull(options);
    }

    private void checkNotDeleted() {
        Preconditions.checkState(!this.mDeleted.get(), "FirebaseApp was deleted");
    }

    void setGetAccessToken(@NonNull IGetAccessToken getAccessToken) {
        this.mGetAccessToken = Preconditions.checkNotNull(getAccessToken);
    }

    public Task<GetTokenResult> getToken(boolean forceRefresh) {
        this.checkNotDeleted();
        if (this.mGetAccessToken == null) {
            return Tasks.forException(new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode."));
        }
        return this.mGetAccessToken.getAccessToken(this.mGetAccessToken.getCurrentUser(), forceRefresh);
    }

    List<AuthStateListener> getListeners() {
        this.checkNotDeleted();
        return this.mAuthStateListeners;
    }

    boolean isDefaultApp() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    void notifyAuthStateListeners(IGetAccessToken getAccessToken, FirebaseUser user) {
        Log.d(LOG_TAG, "Notifying auth state listeners.");
        int size = 0;
        for (AuthStateListener listener : this.mAuthStateListeners) {
            listener.onAuthStateChanged(getAccessToken, user);
            ++size;
        }
        Log.d(LOG_TAG, String.format("Notified %d auth state listeners.", size));
    }

    void addAuthStateListener(@NonNull AuthStateListener listener) {
        this.checkNotDeleted();
        Preconditions.checkNotNull(listener);
        this.mAuthStateListeners.add(listener);
    }

    void removeAuthStateListener(@NonNull AuthStateListener listenerToRemove) {
        this.checkNotDeleted();
        Preconditions.checkNotNull(listenerToRemove);
        this.mAuthStateListeners.remove(listenerToRemove);
    }

    String getPersistenceKey() {
        return FirebaseApp.getPersistenceKey(this.getName(), this.getOptions());
    }

    void addLifecycleEventListener(@NonNull FirebaseAppLifecycleListener listener) {
        this.checkNotDeleted();
        Preconditions.checkNotNull(listener);
        this.mLifecycleListeners.add(listener);
    }

    void removeLifecycleEventListener(@NonNull FirebaseAppLifecycleListener listener) {
        this.checkNotDeleted();
        Preconditions.checkNotNull(listener);
        this.mLifecycleListeners.remove(listener);
    }

    private void notifyOnAppDeleted() {
        for (FirebaseAppLifecycleListener listener : this.mLifecycleListeners) {
            listener.onDeleted(this.mName, this.mOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void clearInstancesForTest() {
        Object object = sLock;
        synchronized (object) {
            sInstances.clear();
        }
    }

    static String getPersistenceKey(String name, FirebaseOptions options) {
        return Base64Utils.encodeUrlSafeNoPadding(name.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAllAppNames() {
        HashSet<String> allAppNames = new HashSet<String>();
        Object object = sLock;
        synchronized (object) {
            for (FirebaseApp app : sInstances.values()) {
                allAppNames.add(app.getName());
            }
            FirebaseAppStore appStore = FirebaseAppStore.getInstance();
            if (appStore != null) {
                allAppNames.addAll(appStore.getAllPersistedAppNames());
            }
        }
        ArrayList<String> sortedNameList = new ArrayList<String>(allAppNames);
        Collections.sort(sortedNameList);
        return sortedNameList;
    }

    private static <T> void initializeApis(Class<T> parameterClass, T parameter, Iterable<String> apiInitClasses) {
        for (String apiInitClass : apiInitClasses) {
            try {
                Class<?> initializerClass = Class.forName(apiInitClass);
                Method initMethod = initializerClass.getMethod("getInstance", parameterClass);
                int publicStaticMask = 9;
                if ((initMethod.getModifiers() & publicStaticMask) == publicStaticMask) {
                    initMethod.invoke(null, parameter);
                }
                String string = String.valueOf(initializerClass);
                Log.d(LOG_TAG, new StringBuilder(13 + String.valueOf(string).length()).append("Initialized ").append(string).append(".").toString());
            }
            catch (ClassNotFoundException e) {
                if (CORE_CLASSES.contains(apiInitClass)) {
                    throw new IllegalStateException(String.valueOf(apiInitClass).concat(" is missing, but is required. Check if it has been removed by Proguard."));
                }
                Log.d(LOG_TAG, String.valueOf(apiInitClass).concat(" is not linked. Skipping initialization."));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(String.valueOf(apiInitClass).concat("#getInstance has been removed by Proguard. Add keep rule to prevent it."));
            }
            catch (InvocationTargetException e) {
                Log.wtf(LOG_TAG, "Firebase API initialization failure.", e);
            }
            catch (IllegalAccessException e) {
                String string = String.valueOf(apiInitClass);
                Log.wtf(LOG_TAG, string.length() != 0 ? "Failed to initialize ".concat(string) : new String("Failed to initialize "), e);
            }
        }
    }

    private static String normalize(@NonNull String name) {
        return name.trim();
    }

    static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull IGetAccessToken var1, @Nullable FirebaseUser var2);
    }
}

