/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.internal.Objects;
import com.google.firebase.internal.Preconditions;
import java.io.IOException;
import java.io.InputStream;

public final class FirebaseOptions {
    private final String mDatabaseUrl;
    private final GoogleCredential mServiceAccountCredential;
    private final String mProjectId;

    private FirebaseOptions(@Nullable String databaseUrl, @NonNull GoogleCredential serviceAccountCredential, @Nullable String projectId) {
        Preconditions.checkState(serviceAccountCredential != null, "Service Account must be provided.");
        this.mDatabaseUrl = databaseUrl;
        this.mServiceAccountCredential = serviceAccountCredential;
        this.mProjectId = projectId;
    }

    public String getDatabaseUrl() {
        return this.mDatabaseUrl;
    }

    public String getProjectId() {
        return this.mProjectId;
    }

    GoogleCredential getServiceAccountCredential() {
        return this.mServiceAccountCredential;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FirebaseOptions)) {
            return false;
        }
        FirebaseOptions other = (FirebaseOptions)o;
        return Objects.equal(this.mDatabaseUrl, other.mDatabaseUrl) && Objects.equal(this.mServiceAccountCredential.getServiceAccountId(), other.mServiceAccountCredential.getServiceAccountId()) && Objects.equal(this.mProjectId, other.mProjectId);
    }

    public int hashCode() {
        return Objects.hashCode(this.mDatabaseUrl, this.mServiceAccountCredential, this.mProjectId);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("databaseUrl", this.mDatabaseUrl).add("serviceAccount", this.mServiceAccountCredential).add("projectId", this.mProjectId).toString();
    }

    public static final class Builder {
        private String mDatabaseUrl;
        private GoogleCredential mServiceAccountCredential;
        private String mProjectId;

        public Builder() {
        }

        public Builder(FirebaseOptions options) {
            this.mDatabaseUrl = options.mDatabaseUrl;
            this.mServiceAccountCredential = options.mServiceAccountCredential;
            this.mProjectId = options.mProjectId;
        }

        public Builder setDatabaseUrl(@Nullable String databaseUrl) {
            this.mDatabaseUrl = databaseUrl;
            return this;
        }

        public Builder setServiceAccount(@NonNull InputStream stream) {
            try {
                this.mServiceAccountCredential = GoogleCredential.fromStream((InputStream)stream);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read service account", e);
            }
            return this;
        }

        public Builder setProjectId(@NonNull String projectId) {
            this.mProjectId = projectId;
            return this;
        }

        public FirebaseOptions build() {
            return new FirebaseOptions(this.mDatabaseUrl, this.mServiceAccountCredential, this.mProjectId);
        }
    }
}

