/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.util.Key;
import java.io.IOException;

public final class FirebaseToken
extends IdToken {
    FirebaseToken(JsonWebSignature.Header header, Payload payload, byte[] signatureBytes, byte[] signedContentBytes) {
        super(header, (IdToken.Payload)payload, signatureBytes, signedContentBytes);
    }

    public Payload getPayload() {
        return (Payload)super.getPayload();
    }

    public static FirebaseToken parse(JsonFactory jsonFactory, String tokenString) throws IOException {
        JsonWebSignature jws = JsonWebSignature.parser((JsonFactory)jsonFactory).setPayloadClass(Payload.class).parse(tokenString);
        return new FirebaseToken(jws.getHeader(), (Payload)jws.getPayload(), jws.getSignatureBytes(), jws.getSignedContentBytes());
    }

    public static class Payload
    extends IdToken.Payload {
        @Key(value="auth_time")
        private long authTime;
        @Key
        private String email;
        @Key(value="email_verified")
        private boolean emailVerified;
        @Key
        private String name;
        @Key
        private String picture;

        public long getAuthTime() {
            return this.authTime;
        }

        public String getEmail() {
            return this.email;
        }

        public boolean isEmailVerified() {
            return this.emailVerified;
        }

        public String getName() {
            return this.name;
        }

        public String getPicture() {
            return this.picture;
        }

        public Payload setIssuer(String issuer) {
            return (Payload)super.setIssuer(issuer);
        }

        public Payload setSubject(String subject) {
            return (Payload)super.setSubject(subject);
        }

        public Payload setAudience(Object audience) {
            return (Payload)super.setAudience(audience);
        }

        public Payload setIssuedAtTimeSeconds(Long issuedAt) {
            return (Payload)super.setIssuedAtTimeSeconds(issuedAt);
        }

        public Payload setExpirationTimeSeconds(Long expirationTime) {
            return (Payload)super.setExpirationTimeSeconds(expirationTime);
        }
    }
}

