/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.internal.Preconditions;
import com.google.firebase.tasks.Task;
import java.net.URI;
import java.util.List;

public abstract class FirebaseUser
implements UserInfo {
    @Override
    @NonNull
    public abstract String getUid();

    @Override
    @NonNull
    public abstract String getProviderId();

    public abstract boolean isAnonymous();

    @Nullable
    public abstract List<String> getProviders();

    @NonNull
    public abstract List<? extends UserInfo> getProviderData();

    @NonNull
    public abstract FirebaseUser setProviderData(@NonNull List<? extends UserInfo> var1);

    public abstract FirebaseUser setIsAnonymous(boolean var1);

    @NonNull
    public abstract FirebaseApp getFirebaseApp();

    @Override
    @Nullable
    public abstract String getDisplayName();

    @Override
    @Nullable
    public abstract URI getProfileUrl();

    @Override
    @Nullable
    public abstract URI getPhotoUrl();

    @Override
    @Nullable
    public abstract String getEmail();

    @NonNull
    public Task<GetTokenResult> getToken(boolean forceRefresh) {
        return ImplFirebaseTrampolines.getIGetAccessToken(this.getFirebaseApp()).getAccessToken(this, forceRefresh);
    }

    @NonNull
    public Task<AuthResult> reload() {
        return ImplFirebaseTrampolines.getIGetAccessToken(this.getFirebaseApp()).reload(this);
    }

    public Task<Void> reauthenticate(@NonNull AuthCredential credential) {
        Preconditions.checkNotNull(credential);
        return ImplFirebaseTrampolines.getIGetAccessToken(this.getFirebaseApp()).reauthenticate(this, credential);
    }

    @NonNull
    public Task<AuthResult> linkWithCredential(@NonNull AuthCredential credential) {
        Preconditions.checkNotNull(credential);
        return ImplFirebaseTrampolines.getIGetAccessToken(this.getFirebaseApp()).linkWithCredential(this, credential);
    }

    public Task<AuthResult> unlink(@NonNull String provider) {
        Preconditions.checkNotEmpty(provider);
        return ImplFirebaseTrampolines.getIGetAccessToken(this.getFirebaseApp()).unlink(this, provider);
    }

    @NonNull
    public Task<Void> updateProfile(@NonNull UserProfileChangeRequest request) {
        Preconditions.checkNotNull(request);
        return ImplFirebaseTrampolines.getIGetAccessToken(this.getFirebaseApp()).updateProfile(this, request);
    }

    @NonNull
    public Task<Void> updateEmail(@NonNull String email) {
        Preconditions.checkNotEmpty(email);
        return ImplFirebaseTrampolines.getIGetAccessToken(this.getFirebaseApp()).updateEmail(this, email);
    }

    @NonNull
    public Task<Void> updatePassword(@NonNull String password) {
        Preconditions.checkNotEmpty(password);
        return ImplFirebaseTrampolines.getIGetAccessToken(this.getFirebaseApp()).updatePassword(this, password);
    }

    @NonNull
    public Task<Void> delete() {
        return ImplFirebaseTrampolines.getIGetAccessToken(this.getFirebaseApp()).delete(this);
    }

    @NonNull
    public abstract String getCachedTokenState();

    public abstract void setCachedTokenState(@NonNull String var1);
}

