/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.internal.Preconditions;
import com.google.firebase.internal.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class GetTokenResult {
    private static final String TOO_MANY_ATTEMPTS_TRY_LATER = "TOO_MANY_ATTEMPTS_TRY_LATER";
    private static final String TOKEN_EXPIRED = "TOKEN_EXPIRED";
    private static final String USER_NOT_FOUND = "USER_NOT_FOUND";
    private String mToken;

    public GetTokenResult(String token) {
        this.mToken = token;
    }

    @Nullable
    public String getToken() {
        return this.mToken;
    }

    @NonNull
    public static Status fromError(String message) {
        if (message == null || message.equals("")) {
            return new Status(17499);
        }
        switch (message) {
            case "TOKEN_EXPIRED": 
            case "USER_NOT_FOUND": {
                return new Status(17021);
            }
        }
        return GetTokenResult.handleDefaultErrorCase(message);
    }

    @NonNull
    private static Status handleDefaultErrorCase(@NonNull String message) {
        Preconditions.checkNotEmpty(message);
        if (message.startsWith(TOO_MANY_ATTEMPTS_TRY_LATER)) {
            return GetTokenResult.handleTooManyAttemptsExtended(message);
        }
        return new Status(17499, message);
    }

    @NonNull
    private static Status handleTooManyAttemptsExtended(@NonNull String message) {
        List<String> tokenized = GetTokenResult.tokenize(message, ":");
        String underlyingMessage = tokenized.size() > 1 ? tokenized.get(1) : tokenized.get(0);
        return new Status(17010, underlyingMessage);
    }

    private static List<String> tokenize(@NonNull String input, @NonNull String tokenize) {
        StringTokenizer tokenizer = new StringTokenizer(input, tokenize);
        ArrayList<String> elements = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            elements.add(tokenizer.nextToken());
        }
        return elements;
    }
}

