/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.firebase.internal.Nullable;
import java.net.URI;
import java.net.URISyntaxException;

public class UserProfileChangeRequest {
    private String mDisplayName;
    private String mPhotoUrl;
    private boolean mRemoveDisplayName;
    private boolean mRemovePhotoUri;
    private URI mPhotoUri;

    UserProfileChangeRequest(String displayName, String photoUrl, boolean shouldRemoveDisplayName, boolean shouldRemovePhotoUri) {
        this.mDisplayName = displayName;
        this.mPhotoUrl = photoUrl;
        this.mRemoveDisplayName = shouldRemoveDisplayName;
        this.mRemovePhotoUri = shouldRemovePhotoUri;
        try {
            this.mPhotoUri = photoUrl == null || "".equals(photoUrl) ? null : new URI(photoUrl);
        }
        catch (URISyntaxException e) {
            this.mPhotoUri = null;
        }
    }

    @Nullable
    public String getDisplayName() {
        return this.mDisplayName;
    }

    public String getPhotoUrl() {
        return this.mPhotoUrl;
    }

    public URI getPhotoUri() {
        return this.mPhotoUri;
    }

    public boolean shouldRemoveDisplayName() {
        return this.mRemoveDisplayName;
    }

    public boolean shouldRemovePhotoUri() {
        return this.mRemovePhotoUri;
    }

    public static class Builder {
        private String mDisplayName;
        private URI mPhotoUri;
        private boolean mRemoveDisplayName;
        private boolean mRemovePhotoUri;

        public Builder setDisplayName(@Nullable String displayName) {
            if (displayName == null) {
                this.mRemoveDisplayName = true;
            } else {
                this.mDisplayName = displayName;
            }
            return this;
        }

        public Builder setPhotoUri(@Nullable URI photoUri) {
            if (photoUri == null) {
                this.mRemovePhotoUri = true;
            } else {
                this.mPhotoUri = photoUri;
            }
            return this;
        }

        public UserProfileChangeRequest build() {
            return new UserProfileChangeRequest(this.mDisplayName, this.mPhotoUri == null ? null : this.mPhotoUri.toString(), this.mRemoveDisplayName, this.mRemovePhotoUri);
        }
    }
}

