/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.auth.openidconnect.IdTokenVerifier;
import com.google.api.client.googleapis.auth.oauth2.GooglePublicKeysManager;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.Clock;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.firebase.auth.FirebaseToken;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Collections;

public final class FirebaseTokenVerifier
extends IdTokenVerifier {
    private static final String ISSUER_PREFIX = "https://securetoken.google.com/";
    @VisibleForTesting
    static final String CLIENT_CERT_URL = "https://www.googleapis.com/robot/v1/metadata/x509/securetoken@system.gserviceaccount.com";
    private String projectId;
    private GooglePublicKeysManager publicKeysManager;

    protected FirebaseTokenVerifier(Builder builder) {
        super((IdTokenVerifier.Builder)builder);
        Preconditions.checkArgument((builder.projectId != null ? 1 : 0) != 0, (Object)"projectId must be set");
        this.projectId = builder.projectId;
        this.publicKeysManager = builder.publicKeysManager;
    }

    public boolean verify(FirebaseToken token) throws GeneralSecurityException, IOException {
        return super.verify((IdToken)token) && ((String)token.getPayload().getAudienceAsList().get(0)).endsWith(this.projectId) && this.verifySignature(token);
    }

    private boolean verifySignature(FirebaseToken token) throws GeneralSecurityException, IOException {
        for (PublicKey key : this.publicKeysManager.getPublicKeys()) {
            if (!token.verifySignature(key)) continue;
            return true;
        }
        return false;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public static class Builder
    extends IdTokenVerifier.Builder {
        String projectId;
        GooglePublicKeysManager publicKeysManager;

        public String getProjectId() {
            return this.projectId;
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            String string = String.valueOf(projectId);
            this.setIssuer(string.length() != 0 ? FirebaseTokenVerifier.ISSUER_PREFIX.concat(string) : new String(FirebaseTokenVerifier.ISSUER_PREFIX));
            this.setAudience(Collections.singleton(projectId));
            return this;
        }

        public Builder setClock(Clock clock) {
            return (Builder)super.setClock(clock);
        }

        public GooglePublicKeysManager getPublicKeyManager() {
            return this.publicKeysManager;
        }

        public Builder setPublicKeysManager(GooglePublicKeysManager publicKeysManager) {
            this.publicKeysManager = publicKeysManager;
            return this;
        }

        public FirebaseTokenVerifier build() {
            if (this.publicKeysManager == null) {
                this.publicKeysManager = new GooglePublicKeysManager.Builder((HttpTransport)new NetHttpTransport.Builder().build(), (JsonFactory)new GsonFactory()).setClock(this.getClock()).setPublicCertsEncodedUrl(FirebaseTokenVerifier.CLIENT_CERT_URL).build();
            }
            return new FirebaseTokenVerifier(this);
        }
    }
}

