/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.connection.ConnectionContext;
import com.google.firebase.database.connection.HostInfo;
import com.google.firebase.database.connection.PersistentConnection;
import com.google.firebase.database.connection.PersistentConnectionImpl;
import com.google.firebase.database.core.AuthTokenProvider;
import com.google.firebase.database.core.Context;
import com.google.firebase.database.core.EventTarget;
import com.google.firebase.database.core.JvmAuthTokenProvider;
import com.google.firebase.database.core.Platform;
import com.google.firebase.database.core.RunLoop;
import com.google.firebase.database.core.ThreadInitializer;
import com.google.firebase.database.core.ThreadPoolEventTarget;
import com.google.firebase.database.core.persistence.PersistenceManager;
import com.google.firebase.database.logging.DefaultLogger;
import com.google.firebase.database.logging.LogWrapper;
import com.google.firebase.database.logging.Logger;
import com.google.firebase.database.utilities.DefaultRunLoop;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

enum JvmPlatform implements Platform
{
    INSTANCE;


    @Override
    public Logger newLogger(Context ctx, Logger.Level level, List<String> components) {
        return new DefaultLogger(level, components);
    }

    @Override
    public EventTarget newEventTarget(Context ctx) {
        return new ThreadPoolEventTarget(Executors.defaultThreadFactory(), ThreadInitializer.defaultInstance);
    }

    @Override
    public RunLoop newRunLoop(Context context) {
        final LogWrapper logger = context.getLogger("RunLoop");
        return new DefaultRunLoop(){

            @Override
            public void handleException(Throwable e) {
                String string = String.valueOf(FirebaseDatabase.getSdkVersion());
                logger.error(new StringBuilder(89 + String.valueOf(string).length()).append("Uncaught exception in Firebase Database runloop (").append(string).append("). Please report to support@firebase.com").toString(), e);
            }
        };
    }

    @Override
    public AuthTokenProvider newAuthTokenProvider(ScheduledExecutorService executorService) {
        return new JvmAuthTokenProvider(executorService);
    }

    @Override
    public PersistentConnection newPersistentConnection(Context context, ConnectionContext connectionContext, HostInfo info, PersistentConnection.Delegate delegate) {
        return new PersistentConnectionImpl(context.getConnectionContext(), info, delegate);
    }

    @Override
    public String getUserAgent(Context ctx) {
        String deviceName = System.getProperty("java.vm.name", "Unknown JVM");
        String systemVersion = System.getProperty("java.specification.version", "Unknown");
        return new StringBuilder(1 + String.valueOf(systemVersion).length() + String.valueOf(deviceName).length()).append(systemVersion).append("/").append(deviceName).toString();
    }

    @Override
    public String getPlatformVersion() {
        String string = String.valueOf(FirebaseDatabase.getSdkVersion());
        return string.length() != 0 ? "jvm-".concat(string) : new String("jvm-");
    }

    @Override
    public PersistenceManager createPersistenceManager(Context ctx, String namespace) {
        return null;
    }

    @Override
    public void runBackgroundTask(final Context ctx, final Runnable r) {
        new Thread(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (Throwable e) {
                    ctx.getLogger("BackgroundTask").error("An unexpected error occurred. Please contact support@firebase.com. Details: ", e);
                    throw new RuntimeException(e);
                }
            }
        }.start();
    }
}

