/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.operation;

import com.google.firebase.database.core.view.QueryParams;

public class OperationSource {
    public static final OperationSource USER = new OperationSource(Source.User, null, false);
    public static final OperationSource SERVER = new OperationSource(Source.Server, null, false);
    private final Source source;
    private final QueryParams queryParams;
    private final boolean tagged;

    public static OperationSource forServerTaggedQuery(QueryParams queryParams) {
        return new OperationSource(Source.Server, queryParams, true);
    }

    public OperationSource(Source source, QueryParams queryParams, boolean tagged) {
        this.source = source;
        this.queryParams = queryParams;
        this.tagged = tagged;
        assert (!tagged || this.isFromServer());
    }

    public boolean isFromUser() {
        return this.source == Source.User;
    }

    public boolean isFromServer() {
        return this.source == Source.Server;
    }

    public boolean isTagged() {
        return this.tagged;
    }

    public String toString() {
        String string = String.valueOf((Object)this.source);
        String string2 = String.valueOf(this.queryParams);
        boolean bl = this.tagged;
        return new StringBuilder(52 + String.valueOf(string).length() + String.valueOf(string2).length()).append("OperationSource{source=").append(string).append(", queryParams=").append(string2).append(", tagged=").append(bl).append("}").toString();
    }

    public QueryParams getQueryParams() {
        return this.queryParams;
    }

    private static enum Source {
        User,
        Server;

    }
}

