/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.tubesock;

import com.google.firebase.database.tubesock.WebSocketException;
import com.google.firebase.internal.Base64;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

class WebSocketHandshake {
    private static final String WEBSOCKET_VERSION = "13";
    private URI url = null;
    private String protocol = null;
    private String nonce = null;
    private Map<String, String> extraHeaders = null;

    public WebSocketHandshake(URI url, String protocol, Map<String, String> extraHeaders) {
        this.url = url;
        this.protocol = protocol;
        this.extraHeaders = extraHeaders;
        this.nonce = this.createNonce();
    }

    public byte[] getHandshake() {
        String fieldName2;
        String string;
        String path = this.url.getPath();
        String query = this.url.getQuery();
        String string2 = String.valueOf(path);
        if (query == null) {
            string = "";
        } else {
            String string3 = String.valueOf(query);
            string = string3.length() != 0 ? "?".concat(string3) : new String("?");
        }
        String string4 = String.valueOf(string);
        path = string4.length() != 0 ? string2.concat(string4) : new String(string2);
        String host = this.url.getHost();
        if (this.url.getPort() != -1) {
            String string5 = String.valueOf(host);
            int n = this.url.getPort();
            host = new StringBuilder(12 + String.valueOf(string5).length()).append(string5).append(":").append(n).toString();
        }
        LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        header.put("Host", host);
        header.put("Upgrade", "websocket");
        header.put("Connection", "Upgrade");
        header.put("Sec-WebSocket-Version", WEBSOCKET_VERSION);
        header.put("Sec-WebSocket-Key", this.nonce);
        if (this.protocol != null) {
            header.put("Sec-WebSocket-Protocol", this.protocol);
        }
        if (this.extraHeaders != null) {
            for (String fieldName2 : this.extraHeaders.keySet()) {
                if (header.containsKey(fieldName2)) continue;
                header.put(fieldName2, this.extraHeaders.get(fieldName2));
            }
        }
        fieldName2 = path;
        String handshake = new StringBuilder(15 + String.valueOf(fieldName2).length()).append("GET ").append(fieldName2).append(" HTTP/1.1\r\n").toString();
        String string6 = String.valueOf(handshake);
        String string7 = String.valueOf(this.generateHeader(header));
        handshake = string7.length() != 0 ? string6.concat(string7) : new String(string6);
        handshake = String.valueOf(handshake).concat("\r\n");
        byte[] handshakeBytes = new byte[handshake.getBytes().length];
        System.arraycopy(handshake.getBytes(), 0, handshakeBytes, 0, handshake.getBytes().length);
        return handshakeBytes;
    }

    private String generateHeader(LinkedHashMap<String, String> headers) {
        String header = new String();
        for (String fieldName : headers.keySet()) {
            String string = String.valueOf(header);
            String string2 = headers.get(fieldName);
            header = new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(fieldName).length() + String.valueOf(string2).length()).append(string).append(fieldName).append(": ").append(string2).append("\r\n").toString();
        }
        return header;
    }

    private String createNonce() {
        byte[] nonce = new byte[16];
        for (int i = 0; i < 16; ++i) {
            nonce[i] = (byte)this.rand(0, 255);
        }
        return Base64.encodeToString(nonce, 2);
    }

    public void verifyServerStatusLine(String statusLine) {
        int statusCode = Integer.valueOf(statusLine.substring(9, 12));
        if (statusCode == 407) {
            throw new WebSocketException("connection failed: proxy authentication not supported");
        }
        if (statusCode == 404) {
            throw new WebSocketException("connection failed: 404 not found");
        }
        if (statusCode != 101) {
            throw new WebSocketException(new StringBuilder(50).append("connection failed: unknown status code ").append(statusCode).toString());
        }
    }

    public void verifyServerHandshakeHeaders(HashMap<String, String> headers) {
        if (!headers.get("Upgrade").toLowerCase(Locale.US).equals("websocket")) {
            throw new WebSocketException("connection failed: missing header field in server handshake: Upgrade");
        }
        if (!headers.get("Connection").toLowerCase(Locale.US).equals("upgrade")) {
            throw new WebSocketException("connection failed: missing header field in server handshake: Connection");
        }
    }

    private int rand(int min, int max) {
        int rand = (int)(Math.random() * (double)max + (double)min);
        return rand;
    }
}

