/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.util;

import com.google.firebase.database.util.JsonMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class GAuthToken {
    private final String token;
    private final String uid;
    private static final String TOKEN_PREFIX = "gauth|";
    private static final String UID_KEY = "uid";
    private static final String TOKEN_KEY = "token";

    public GAuthToken(String token, String uid) {
        this.token = token;
        this.uid = uid;
    }

    public static GAuthToken tryParseFromString(String rawToken) {
        if (!rawToken.startsWith(TOKEN_PREFIX)) {
            return null;
        }
        String gauthToken = rawToken.substring(TOKEN_PREFIX.length());
        try {
            Map<String, Object> tokenMap = JsonMapper.parseJson(gauthToken);
            String token = (String)tokenMap.get(TOKEN_KEY);
            String uid = (String)tokenMap.get(UID_KEY);
            return new GAuthToken(token, uid);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse gauth token", e);
        }
    }

    public String serializeToString() {
        HashMap<String, Object> tokenMap = new HashMap<String, Object>();
        tokenMap.put(TOKEN_KEY, this.token);
        tokenMap.put(UID_KEY, this.uid);
        try {
            String json = JsonMapper.serializeJson(tokenMap);
            String string = String.valueOf(TOKEN_PREFIX);
            String string2 = String.valueOf(json);
            return string2.length() != 0 ? string.concat(string2) : new String(string);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize gauth token", e);
        }
    }

    public String getToken() {
        return this.token;
    }

    public String getUid() {
        return this.uid;
    }
}

