/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.utilities;

import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.ValidationPath;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.NodeUtilities;
import com.google.firebase.database.snapshot.PriorityUtilities;
import com.google.firebase.database.utilities.Utilities;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class Validation {
    private static final Pattern INVALID_PATH_REGEX = Pattern.compile("[\\[\\]\\.#$]");
    private static final Pattern INVALID_KEY_REGEX = Pattern.compile("[\\[\\]\\.#\\$\\/\\u0000-\\u001F\\u007F]");

    private static boolean isValidPathString(String pathString) {
        return !INVALID_PATH_REGEX.matcher(pathString).find();
    }

    public static void validatePathString(String pathString) throws DatabaseException {
        if (!Validation.isValidPathString(pathString)) {
            throw new DatabaseException(new StringBuilder(101 + String.valueOf(pathString).length()).append("Invalid Firebase Database path: ").append(pathString).append(". Firebase Database paths must not contain '.', '#', '$', '[', or ']'").toString());
        }
    }

    public static void validateRootPathString(String pathString) throws DatabaseException {
        if (pathString.startsWith(".info")) {
            Validation.validatePathString(pathString.substring(5));
        } else if (pathString.startsWith("/.info")) {
            Validation.validatePathString(pathString.substring(6));
        } else {
            Validation.validatePathString(pathString);
        }
    }

    private static boolean isWritableKey(String key) {
        return key != null && key.length() > 0 && (key.equals(".value") || key.equals(".priority") || !key.startsWith(".") && !INVALID_KEY_REGEX.matcher(key).find());
    }

    private static boolean isValidKey(String key) {
        return key.equals(".info") || !INVALID_KEY_REGEX.matcher(key).find();
    }

    public static void validateNullableKey(String key) throws DatabaseException {
        if (key != null && !Validation.isValidKey(key)) {
            throw new DatabaseException(new StringBuilder(68 + String.valueOf(key).length()).append("Invalid key: ").append(key).append(". Keys must not contain '/', '.', '#', '$', '[', or ']'").toString());
        }
    }

    private static boolean isWritablePath(Path path) {
        ChildKey front = path.getFront();
        return front == null || !front.asString().startsWith(".");
    }

    public static void validateWritableObject(Object object) {
        block4: {
            block3: {
                if (!(object instanceof Map)) break block3;
                Map map = (Map)object;
                if (map.containsKey(".sv")) {
                    return;
                }
                for (Map.Entry entry : map.entrySet()) {
                    Validation.validateWritableKey((String)entry.getKey());
                    Validation.validateWritableObject(entry.getValue());
                }
                break block4;
            }
            if (!(object instanceof List)) break block4;
            List list = (List)object;
            for (Object child : list) {
                Validation.validateWritableObject(child);
            }
        }
    }

    public static void validateWritableKey(String key) throws DatabaseException {
        if (!Validation.isWritableKey(key)) {
            throw new DatabaseException(new StringBuilder(68 + String.valueOf(key).length()).append("Invalid key: ").append(key).append(". Keys must not contain '/', '.', '#', '$', '[', or ']'").toString());
        }
    }

    public static void validateWritablePath(Path path) throws DatabaseException {
        if (!Validation.isWritablePath(path)) {
            String string = String.valueOf(path.toString());
            throw new DatabaseException(string.length() != 0 ? "Invalid write location: ".concat(string) : new String("Invalid write location: "));
        }
    }

    public static Map<Path, Node> parseAndValidateUpdate(Path path, Map<String, Object> update) throws DatabaseException {
        TreeMap<Path, Node> parsedUpdate = new TreeMap<Path, Node>();
        for (Map.Entry<String, Object> entry : update.entrySet()) {
            String childName;
            Path updatePath = new Path(entry.getKey());
            Object newValue = entry.getValue();
            ValidationPath.validateWithObject(path.child(updatePath), newValue);
            String string = childName = !updatePath.isEmpty() ? updatePath.getBack().asString() : "";
            if (childName.equals(".sv") || childName.equals(".value")) {
                String string2 = String.valueOf(updatePath);
                throw new DatabaseException(new StringBuilder(40 + String.valueOf(string2).length() + String.valueOf(childName).length()).append("Path '").append(string2).append("' contains disallowed child name: ").append(childName).toString());
            }
            if (childName.equals(".priority") && !PriorityUtilities.isValidPriority(NodeUtilities.NodeFromJSON(newValue))) {
                String string3 = String.valueOf(updatePath);
                throw new DatabaseException(new StringBuilder(83 + String.valueOf(string3).length()).append("Path '").append(string3).append("' contains invalid priority (must be a string, double, ServerValue, or null).").toString());
            }
            Validation.validateWritableObject(newValue);
            parsedUpdate.put(updatePath, NodeUtilities.NodeFromJSON(newValue));
        }
        Path prevPath = null;
        for (Path curPath : parsedUpdate.keySet()) {
            Utilities.hardAssert(prevPath == null || prevPath.compareTo(curPath) < 0);
            if (prevPath != null && prevPath.contains(curPath)) {
                String string = String.valueOf(prevPath);
                String string4 = String.valueOf(curPath);
                throw new DatabaseException(new StringBuilder(42 + String.valueOf(string).length() + String.valueOf(string4).length()).append("Path '").append(string).append("' is an ancestor of '").append(string4).append("' in an update.").toString());
            }
            prevPath = curPath;
        }
        return parsedUpdate;
    }
}

