/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend.log4j2;

import com.google.common.flogger.backend.LogData;
import com.google.common.flogger.backend.LoggerBackend;
import com.google.common.flogger.backend.log4j2.Log4j2SimpleLogEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

final class Log4j2LoggerBackend
extends LoggerBackend {
    private final org.apache.logging.log4j.core.Logger logger;

    static Level toLog4jLevel(java.util.logging.Level level) {
        int logLevel = level.intValue();
        if (logLevel >= java.util.logging.Level.SEVERE.intValue()) {
            return Level.ERROR;
        }
        if (logLevel >= java.util.logging.Level.WARNING.intValue()) {
            return Level.WARN;
        }
        if (logLevel >= java.util.logging.Level.INFO.intValue()) {
            return Level.INFO;
        }
        if (logLevel >= java.util.logging.Level.FINE.intValue()) {
            return Level.DEBUG;
        }
        return Level.TRACE;
    }

    Log4j2LoggerBackend(org.apache.logging.log4j.core.Logger logger) {
        this.logger = logger;
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public boolean isLoggable(java.util.logging.Level level) {
        return this.logger.isEnabled(Log4j2LoggerBackend.toLog4jLevel(level));
    }

    private void log(Log4j2SimpleLogEvent logEntry, boolean wasForced) {
        if (wasForced || this.logger.isEnabled(logEntry.getLevel())) {
            this.logger.get().log(logEntry.asLoggingEvent());
        }
    }

    public void log(LogData logData) {
        this.log(Log4j2SimpleLogEvent.create((Logger)this.logger, logData), logData.wasForced());
    }

    public void handleError(RuntimeException error, LogData badData) {
        this.log(Log4j2SimpleLogEvent.error((Logger)this.logger, error, badData), badData.wasForced());
    }
}

