/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend.log4j2;

import com.google.common.flogger.backend.LogData;
import com.google.common.flogger.backend.SimpleMessageFormatter;
import com.google.common.flogger.backend.log4j2.Log4j2LogDataFormatter;
import com.google.common.flogger.backend.log4j2.Log4j2LoggerBackend;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;

final class Log4j2SimpleLogEvent
implements SimpleMessageFormatter.SimpleLogHandler {
    private final Logger logger;
    private final LogData logData;
    private Level level = null;
    private String message = null;
    private Throwable thrown = null;

    static Log4j2SimpleLogEvent create(Logger logger, LogData data) {
        return new Log4j2SimpleLogEvent(logger, data);
    }

    static Log4j2SimpleLogEvent error(Logger logger, RuntimeException error, LogData data) {
        return new Log4j2SimpleLogEvent(logger, data, error);
    }

    private Log4j2SimpleLogEvent(Logger logger, LogData logData) {
        this.logger = logger;
        this.logData = logData;
        Log4j2LogDataFormatter.format(logData, this);
    }

    private Log4j2SimpleLogEvent(Logger logger, LogData badLogData, RuntimeException error) {
        this.logger = logger;
        this.logData = badLogData;
        Log4j2LogDataFormatter.formatBadLogData(error, badLogData, this);
    }

    public void handleFormattedLogMessage(java.util.logging.Level level, String message, Throwable thrown) {
        this.level = Log4j2LoggerBackend.toLog4jLevel(level);
        this.message = message;
        this.thrown = thrown;
    }

    Level getLevel() {
        return this.level;
    }

    LogEvent asLoggingEvent() {
        Map mdcProperties = Collections.emptyMap();
        return Log4jLogEvent.newBuilder().setLoggerName(this.logger.toString()).setLoggerFqcn(null).setLevel(this.level).setMessage((Message)new SimpleMessage(this.message)).setThreadName(Thread.currentThread().getName()).setTimeMillis(TimeUnit.NANOSECONDS.toMillis(this.logData.getTimestampNanos())).setThrown(this.thrown != null ? Throwables.getRootCause((Throwable)this.thrown) : null).setContextMap(mdcProperties).build();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.getClass().getSimpleName()).append(" {\n  message: ").append(this.message).append('\n');
        Log4j2LogDataFormatter.appendLogData(this.logData, out);
        out.append("\n}");
        return out.toString();
    }
}

