/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend.slf4j;

import com.google.common.flogger.LogContext;
import com.google.common.flogger.backend.LogData;
import com.google.common.flogger.backend.LoggerBackend;
import com.google.common.flogger.backend.MessageUtils;
import com.google.common.flogger.backend.Metadata;
import com.google.common.flogger.backend.MetadataProcessor;
import com.google.common.flogger.backend.Platform;
import com.google.common.flogger.backend.SimpleMessageFormatter;
import java.util.logging.Level;
import org.slf4j.Logger;

final class Slf4jLoggerBackend
extends LoggerBackend {
    private static final int JDK_ALL_LEVEL_VALUE = Level.ALL.intValue();
    private static final int JDK_OFF_LEVEL_VALUE = Level.OFF.intValue();
    private static final int JDK_FINE_LEVEL_VALUE = Level.FINE.intValue();
    private static final int JDK_INFO_LEVEL_VALUE = Level.INFO.intValue();
    private static final int JDK_WARNING_LEVEL_VALUE = Level.WARNING.intValue();
    private static final int JDK_SEVERE_LEVEL_VALUE = Level.SEVERE.intValue();
    private final Logger logger;

    Slf4jLoggerBackend(Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger is required");
        }
        this.logger = logger;
    }

    private static Slf4jLogLevel mapToSlf4jLogLevel(Level level) {
        int requestedLevel = level.intValue();
        if (requestedLevel == JDK_ALL_LEVEL_VALUE || requestedLevel == JDK_OFF_LEVEL_VALUE) {
            throw new IllegalArgumentException("Unsupported log level: " + level);
        }
        if (requestedLevel < JDK_FINE_LEVEL_VALUE) {
            return Slf4jLogLevel.TRACE;
        }
        if (requestedLevel < JDK_INFO_LEVEL_VALUE) {
            return Slf4jLogLevel.DEBUG;
        }
        if (requestedLevel < JDK_WARNING_LEVEL_VALUE) {
            return Slf4jLogLevel.INFO;
        }
        if (requestedLevel < JDK_SEVERE_LEVEL_VALUE) {
            return Slf4jLogLevel.WARN;
        }
        return Slf4jLogLevel.ERROR;
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public boolean isLoggable(Level level) {
        Slf4jLogLevel slf4jLogLevel = Slf4jLoggerBackend.mapToSlf4jLogLevel(level);
        switch (slf4jLogLevel) {
            case TRACE: {
                return this.logger.isTraceEnabled();
            }
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case INFO: {
                return this.logger.isInfoEnabled();
            }
            case WARN: {
                return this.logger.isWarnEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
        }
        throw new AssertionError((Object)("Unknown SLF4J log level: " + (Object)((Object)slf4jLogLevel)));
    }

    public void log(LogData logData) {
        MetadataProcessor metadata = MetadataProcessor.forScopeAndLogSite((Metadata)Platform.getInjectedMetadata(), (Metadata)logData.getMetadata());
        String message = SimpleMessageFormatter.getDefaultFormatter().format(logData, metadata);
        Throwable thrown = (Throwable)metadata.getSingleValue(LogContext.Key.LOG_CAUSE);
        Slf4jLogLevel slf4jLogLevel = Slf4jLoggerBackend.mapToSlf4jLogLevel(logData.getLevel());
        switch (slf4jLogLevel) {
            case TRACE: {
                this.logger.trace(message, thrown);
                return;
            }
            case DEBUG: {
                this.logger.debug(message, thrown);
                return;
            }
            case INFO: {
                this.logger.info(message, thrown);
                return;
            }
            case WARN: {
                this.logger.warn(message, thrown);
                return;
            }
            case ERROR: {
                this.logger.error(message, thrown);
                return;
            }
        }
        throw new AssertionError((Object)("Unknown SLF4J log level: " + (Object)((Object)slf4jLogLevel)));
    }

    public void handleError(RuntimeException exception, LogData badData) {
        StringBuilder errorMsg = new StringBuilder(200);
        errorMsg.append("LOGGING ERROR: ").append(exception.getMessage());
        Slf4jLoggerBackend.appendBadLogData(badData, errorMsg);
        this.logger.error(errorMsg.toString(), (Throwable)exception);
    }

    private static void appendBadLogData(LogData data, StringBuilder out) {
        out.append("\n  original message: ");
        if (data.getTemplateContext() == null) {
            out.append(data.getLiteralArgument());
        } else {
            out.append(data.getTemplateContext().getMessage());
            out.append("\n  original arguments:");
            for (Object arg : data.getArguments()) {
                out.append("\n    ").append(MessageUtils.safeToString((Object)arg));
            }
        }
        Metadata metadata = data.getMetadata();
        if (metadata.size() > 0) {
            out.append("\n  metadata:");
            for (int n = 0; n < metadata.size(); ++n) {
                out.append("\n    ");
                out.append(metadata.getKey(n).getLabel()).append(": ").append(metadata.getValue(n));
            }
        }
        out.append("\n  level: ").append(data.getLevel());
        out.append("\n  timestamp (nanos): ").append(data.getTimestampNanos());
        out.append("\n  class: ").append(data.getLogSite().getClassName());
        out.append("\n  method: ").append(data.getLogSite().getMethodName());
        out.append("\n  line number: ").append(data.getLogSite().getLineNumber());
    }

    private static enum Slf4jLogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

