/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger;

import com.google.common.flogger.AbstractLogger;
import com.google.common.flogger.GoogleLogContext;
import com.google.common.flogger.GoogleLoggingApi;
import com.google.common.flogger.backend.LoggerBackend;
import com.google.common.flogger.backend.Platform;
import com.google.common.flogger.util.Checks;
import java.util.logging.Level;

public final class GoogleLogger
extends AbstractLogger<Api> {
    private static final NoOp NO_OP = new NoOp();

    public static GoogleLogger forEnclosingClass() {
        String loggingClass = Platform.getCallerFinder().findLoggingClass(GoogleLogger.class);
        return new GoogleLogger(Platform.getBackend((String)loggingClass));
    }

    @Deprecated
    public static GoogleLogger forInjectedClassName(String className) {
        Checks.checkArgument((!className.isEmpty() ? 1 : 0) != 0, (String)"injected class name is empty");
        return new GoogleLogger(Platform.getBackend((String)className.replace('/', '.')));
    }

    GoogleLogger(LoggerBackend loggerBackend) {
        super(loggerBackend);
    }

    public Api at(Level level) {
        boolean isLoggable = this.isLoggable(level);
        boolean isForced = Platform.shouldForceLogging((String)this.getName(), (Level)level, (boolean)isLoggable);
        if (isLoggable || isForced) {
            return this.newContext(level, isForced);
        }
        return NO_OP;
    }

    private Context newContext(Level level, boolean isForced) {
        return new Context(level, isForced);
    }

    private static final class NoOp
    extends GoogleLoggingApi.NoOp<Api>
    implements Api {
        private NoOp() {
        }
    }

    private final class Context
    extends GoogleLogContext<GoogleLogger, Api>
    implements Api {
        Context(Level level, boolean isForced) {
            super(level, isForced);
        }

        protected GoogleLogger getLogger() {
            return GoogleLogger.this;
        }

        protected Api api() {
            return this;
        }

        protected Api noOp() {
            return NO_OP;
        }
    }

    public static interface Api
    extends GoogleLoggingApi<Api> {
    }
}

