/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.api.client.util.Data;
import com.google.api.services.bigquery.model.Table;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.gcloud.bigquery.ExternalTableInfo;
import com.google.gcloud.bigquery.Schema;
import com.google.gcloud.bigquery.TableId;
import com.google.gcloud.bigquery.TableInfo;
import com.google.gcloud.bigquery.ViewInfo;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;

public abstract class BaseTableInfo
implements Serializable {
    static final Function<Table, BaseTableInfo> FROM_PB_FUNCTION = new Function<Table, BaseTableInfo>(){

        public BaseTableInfo apply(Table pb) {
            return BaseTableInfo.fromPb(pb);
        }
    };
    static final Function<BaseTableInfo, Table> TO_PB_FUNCTION = new Function<BaseTableInfo, Table>(){

        public Table apply(BaseTableInfo tableInfo) {
            return tableInfo.toPb();
        }
    };
    private static final long serialVersionUID = -7679032506430816205L;
    private final String etag;
    private final String id;
    private final String selfLink;
    private final TableId tableId;
    private final Type type;
    private final Schema schema;
    private final String friendlyName;
    private final String description;
    private final Long numBytes;
    private final Long numRows;
    private final Long creationTime;
    private final Long expirationTime;
    private final Long lastModifiedTime;

    protected BaseTableInfo(Builder builder) {
        this.tableId = (TableId)Preconditions.checkNotNull((Object)builder.tableId);
        this.etag = builder.etag;
        this.id = builder.id;
        this.selfLink = builder.selfLink;
        this.friendlyName = builder.friendlyName;
        this.description = builder.description;
        this.type = builder.type;
        this.schema = builder.schema;
        this.numBytes = builder.numBytes;
        this.numRows = builder.numRows;
        this.creationTime = builder.creationTime;
        this.expirationTime = builder.expirationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public Type type() {
        return this.type;
    }

    public Schema schema() {
        return this.schema;
    }

    public String selfLink() {
        return this.selfLink;
    }

    public TableId tableId() {
        return this.tableId;
    }

    public String friendlyName() {
        return Data.isNull((Object)this.friendlyName) ? null : this.friendlyName;
    }

    public String description() {
        return Data.isNull((Object)this.description) ? null : this.description;
    }

    public Long numBytes() {
        return this.numBytes;
    }

    public Long numRows() {
        return this.numRows;
    }

    public Long creationTime() {
        return this.creationTime;
    }

    public Long expirationTime() {
        return Data.isNull((Object)this.expirationTime) ? null : this.expirationTime;
    }

    public Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public abstract Builder toBuilder();

    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("tableId", (Object)this.tableId).add("type", (Object)this.type).add("schema", (Object)this.schema).add("etag", (Object)this.etag).add("id", (Object)this.id).add("selfLink", (Object)this.selfLink).add("friendlyName", (Object)this.friendlyName).add("description", (Object)this.description).add("numBytes", (Object)this.numBytes).add("numRows", (Object)this.numRows).add("expirationTime", (Object)this.expirationTime).add("creationTime", (Object)this.creationTime).add("lastModifiedTime", (Object)this.lastModifiedTime);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    protected final int baseHashCode() {
        return Objects.hash(this.tableId);
    }

    protected final boolean baseEquals(BaseTableInfo tableInfo) {
        return Objects.equals(this.toPb(), tableInfo.toPb());
    }

    Table toPb() {
        Table tablePb = new Table();
        tablePb.setTableReference(this.tableId.toPb());
        if (this.lastModifiedTime != null) {
            tablePb.setLastModifiedTime(BigInteger.valueOf(this.lastModifiedTime));
        }
        if (this.numRows != null) {
            tablePb.setNumRows(BigInteger.valueOf(this.numRows));
        }
        if (this.schema != null) {
            tablePb.setSchema(this.schema.toPb());
        }
        tablePb.setType(this.type.name());
        tablePb.setCreationTime(this.creationTime);
        tablePb.setDescription(this.description);
        tablePb.setEtag(this.etag);
        tablePb.setExpirationTime(this.expirationTime);
        tablePb.setFriendlyName(this.friendlyName);
        tablePb.setId(this.id);
        tablePb.setNumBytes(this.numBytes);
        tablePb.setSelfLink(this.selfLink);
        return tablePb;
    }

    static <T extends BaseTableInfo> T fromPb(Table tablePb) {
        switch (Type.valueOf(tablePb.getType())) {
            case TABLE: {
                return (T)TableInfo.fromPb(tablePb);
            }
            case VIEW: {
                return (T)ViewInfo.fromPb(tablePb);
            }
            case EXTERNAL: {
                return (T)ExternalTableInfo.fromPb(tablePb);
            }
        }
        throw new IllegalArgumentException("Format " + tablePb.getType() + " is not supported");
    }

    public static abstract class Builder<T extends BaseTableInfo, B extends Builder<T, B>> {
        private String etag;
        private String id;
        private String selfLink;
        private TableId tableId;
        private Type type;
        private Schema schema;
        private String friendlyName;
        private String description;
        private Long numBytes;
        private Long numRows;
        private Long creationTime;
        private Long expirationTime;
        private Long lastModifiedTime;

        protected Builder() {
        }

        protected Builder(BaseTableInfo tableInfo) {
            this.etag = tableInfo.etag;
            this.id = tableInfo.id;
            this.selfLink = tableInfo.selfLink;
            this.tableId = tableInfo.tableId;
            this.type = tableInfo.type;
            this.schema = tableInfo.schema;
            this.friendlyName = tableInfo.friendlyName;
            this.description = tableInfo.description;
            this.numBytes = tableInfo.numBytes;
            this.numRows = tableInfo.numRows;
            this.creationTime = tableInfo.creationTime;
            this.expirationTime = tableInfo.expirationTime;
            this.lastModifiedTime = tableInfo.lastModifiedTime;
        }

        protected Builder(Table tablePb) {
            this.type = Type.valueOf(tablePb.getType());
            this.tableId = TableId.fromPb(tablePb.getTableReference());
            if (tablePb.getSchema() != null) {
                this.schema(Schema.fromPb(tablePb.getSchema()));
            }
            if (tablePb.getLastModifiedTime() != null) {
                this.lastModifiedTime(tablePb.getLastModifiedTime().longValue());
            }
            if (tablePb.getNumRows() != null) {
                this.numRows(tablePb.getNumRows().longValue());
            }
            this.description = tablePb.getDescription();
            this.expirationTime = tablePb.getExpirationTime();
            this.friendlyName = tablePb.getFriendlyName();
            this.creationTime = tablePb.getCreationTime();
            this.etag = tablePb.getEtag();
            this.id = tablePb.getId();
            this.numBytes = tablePb.getNumBytes();
            this.selfLink = tablePb.getSelfLink();
        }

        protected B self() {
            return (B)this;
        }

        B creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this.self();
        }

        public B description(String description) {
            this.description = (String)MoreObjects.firstNonNull((Object)description, (Object)Data.nullOf(String.class));
            return this.self();
        }

        B etag(String etag) {
            this.etag = etag;
            return this.self();
        }

        public B expirationTime(Long expirationTime) {
            this.expirationTime = (Long)MoreObjects.firstNonNull((Object)expirationTime, (Object)Data.nullOf(Long.class));
            return this.self();
        }

        public B friendlyName(String friendlyName) {
            this.friendlyName = (String)MoreObjects.firstNonNull((Object)friendlyName, (Object)Data.nullOf(String.class));
            return this.self();
        }

        B id(String id) {
            this.id = id;
            return this.self();
        }

        B lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this.self();
        }

        B numBytes(Long numBytes) {
            this.numBytes = numBytes;
            return this.self();
        }

        B numRows(Long numRows) {
            this.numRows = numRows;
            return this.self();
        }

        B selfLink(String selfLink) {
            this.selfLink = selfLink;
            return this.self();
        }

        public B tableId(TableId tableId) {
            this.tableId = (TableId)Preconditions.checkNotNull((Object)tableId);
            return this.self();
        }

        B type(Type type) {
            this.type = type;
            return this.self();
        }

        public B schema(Schema schema) {
            this.schema = (Schema)Preconditions.checkNotNull((Object)schema);
            return this.self();
        }

        public abstract T build();
    }

    public static enum Type {
        TABLE,
        VIEW,
        EXTERNAL;

    }
}

