/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gcloud.Page;
import com.google.gcloud.Service;
import com.google.gcloud.bigquery.BaseTableInfo;
import com.google.gcloud.bigquery.BigQueryException;
import com.google.gcloud.bigquery.BigQueryOptions;
import com.google.gcloud.bigquery.DatasetId;
import com.google.gcloud.bigquery.DatasetInfo;
import com.google.gcloud.bigquery.FieldValue;
import com.google.gcloud.bigquery.InsertAllRequest;
import com.google.gcloud.bigquery.InsertAllResponse;
import com.google.gcloud.bigquery.JobId;
import com.google.gcloud.bigquery.JobInfo;
import com.google.gcloud.bigquery.JobStatus;
import com.google.gcloud.bigquery.LoadConfiguration;
import com.google.gcloud.bigquery.Option;
import com.google.gcloud.bigquery.QueryRequest;
import com.google.gcloud.bigquery.QueryResponse;
import com.google.gcloud.bigquery.TableDataWriteChannel;
import com.google.gcloud.bigquery.TableId;
import com.google.gcloud.spi.BigQueryRpc;
import java.util.HashSet;
import java.util.List;

public interface BigQuery
extends Service<BigQueryOptions> {
    public DatasetInfo create(DatasetInfo var1, DatasetOption ... var2) throws BigQueryException;

    public <T extends BaseTableInfo> T create(T var1, TableOption ... var2) throws BigQueryException;

    public <T extends JobInfo> T create(T var1, JobOption ... var2) throws BigQueryException;

    public DatasetInfo getDataset(String var1, DatasetOption ... var2) throws BigQueryException;

    public DatasetInfo getDataset(DatasetId var1, DatasetOption ... var2) throws BigQueryException;

    public Page<DatasetInfo> listDatasets(DatasetListOption ... var1) throws BigQueryException;

    public boolean delete(String var1, DatasetDeleteOption ... var2) throws BigQueryException;

    public boolean delete(DatasetId var1, DatasetDeleteOption ... var2) throws BigQueryException;

    public boolean delete(String var1, String var2) throws BigQueryException;

    public boolean delete(TableId var1) throws BigQueryException;

    public DatasetInfo update(DatasetInfo var1, DatasetOption ... var2) throws BigQueryException;

    public <T extends BaseTableInfo> T update(T var1, TableOption ... var2) throws BigQueryException;

    public <T extends BaseTableInfo> T getTable(String var1, String var2, TableOption ... var3) throws BigQueryException;

    public <T extends BaseTableInfo> T getTable(TableId var1, TableOption ... var2) throws BigQueryException;

    public Page<BaseTableInfo> listTables(String var1, TableListOption ... var2) throws BigQueryException;

    public Page<BaseTableInfo> listTables(DatasetId var1, TableListOption ... var2) throws BigQueryException;

    public InsertAllResponse insertAll(InsertAllRequest var1) throws BigQueryException;

    public Page<List<FieldValue>> listTableData(String var1, String var2, TableDataListOption ... var3) throws BigQueryException;

    public Page<List<FieldValue>> listTableData(TableId var1, TableDataListOption ... var2) throws BigQueryException;

    public <T extends JobInfo> T getJob(String var1, JobOption ... var2) throws BigQueryException;

    public <T extends JobInfo> T getJob(JobId var1, JobOption ... var2) throws BigQueryException;

    public Page<JobInfo> listJobs(JobListOption ... var1) throws BigQueryException;

    public boolean cancel(String var1) throws BigQueryException;

    public boolean cancel(JobId var1) throws BigQueryException;

    public QueryResponse query(QueryRequest var1) throws BigQueryException;

    public QueryResponse getQueryResults(JobId var1, QueryResultsOption ... var2) throws BigQueryException;

    public TableDataWriteChannel writer(LoadConfiguration var1);

    public static class QueryResultsOption
    extends Option {
        private static final long serialVersionUID = 3788898503226985525L;

        private QueryResultsOption(BigQueryRpc.Option option, Object value) {
            super(option, value);
        }

        public static QueryResultsOption maxResults(long maxResults) {
            Preconditions.checkArgument((maxResults >= 0L ? 1 : 0) != 0);
            return new QueryResultsOption(BigQueryRpc.Option.MAX_RESULTS, maxResults);
        }

        public static QueryResultsOption startPageToken(String pageToken) {
            return new QueryResultsOption(BigQueryRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static QueryResultsOption startIndex(long startIndex) {
            Preconditions.checkArgument((startIndex >= 0L ? 1 : 0) != 0);
            return new QueryResultsOption(BigQueryRpc.Option.START_INDEX, startIndex);
        }

        public static QueryResultsOption maxWaitTime(long maxWaitTime) {
            Preconditions.checkArgument((maxWaitTime >= 0L ? 1 : 0) != 0);
            return new QueryResultsOption(BigQueryRpc.Option.TIMEOUT, maxWaitTime);
        }
    }

    public static class JobOption
    extends Option {
        private static final long serialVersionUID = -3111736712316353665L;

        private JobOption(BigQueryRpc.Option option, Object value) {
            super(option, value);
        }

        public static JobOption fields(JobField ... fields) {
            return new JobOption(BigQueryRpc.Option.FIELDS, JobField.selector(fields));
        }
    }

    public static class JobListOption
    extends Option {
        private static final long serialVersionUID = -8207122131226481423L;

        private JobListOption(BigQueryRpc.Option option, Object value) {
            super(option, value);
        }

        public static JobListOption allUsers() {
            return new JobListOption(BigQueryRpc.Option.ALL_USERS, true);
        }

        public static JobListOption stateFilter(JobStatus.State ... stateFilters) {
            List stringFilters = Lists.transform((List)ImmutableList.copyOf((Object[])stateFilters), (Function)new Function<JobStatus.State, String>(){

                public String apply(JobStatus.State state) {
                    return state.name().toLowerCase();
                }
            });
            return new JobListOption(BigQueryRpc.Option.STATE_FILTER, stringFilters);
        }

        public static JobListOption maxResults(long maxResults) {
            Preconditions.checkArgument((maxResults >= 0L ? 1 : 0) != 0);
            return new JobListOption(BigQueryRpc.Option.MAX_RESULTS, maxResults);
        }

        public static JobListOption startPageToken(String pageToken) {
            return new JobListOption(BigQueryRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static JobListOption fields(JobField ... fields) {
            String selector = JobField.selector(fields);
            StringBuilder builder = new StringBuilder();
            builder.append("etag,jobs(").append(selector).append(",state,errorResult),nextPageToken");
            return new JobListOption(BigQueryRpc.Option.FIELDS, builder.toString());
        }
    }

    public static class TableDataListOption
    extends Option {
        private static final long serialVersionUID = 8488823381738864434L;

        private TableDataListOption(BigQueryRpc.Option option, Object value) {
            super(option, value);
        }

        public static TableDataListOption maxResults(long maxResults) {
            Preconditions.checkArgument((maxResults >= 0L ? 1 : 0) != 0);
            return new TableDataListOption(BigQueryRpc.Option.MAX_RESULTS, maxResults);
        }

        public static TableDataListOption startPageToken(String pageToken) {
            return new TableDataListOption(BigQueryRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static TableDataListOption startIndex(long index) {
            Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0);
            return new TableDataListOption(BigQueryRpc.Option.START_INDEX, index);
        }
    }

    public static class TableOption
    extends Option {
        private static final long serialVersionUID = -1723870134095936772L;

        private TableOption(BigQueryRpc.Option option, Object value) {
            super(option, value);
        }

        public static TableOption fields(TableField ... fields) {
            return new TableOption(BigQueryRpc.Option.FIELDS, TableField.selector(fields));
        }
    }

    public static class TableListOption
    extends Option {
        private static final long serialVersionUID = 8660294969063340498L;

        private TableListOption(BigQueryRpc.Option option, Object value) {
            super(option, value);
        }

        public static TableListOption maxResults(long maxResults) {
            Preconditions.checkArgument((maxResults >= 0L ? 1 : 0) != 0);
            return new TableListOption(BigQueryRpc.Option.MAX_RESULTS, maxResults);
        }

        public static TableListOption startPageToken(String pageToken) {
            return new TableListOption(BigQueryRpc.Option.PAGE_TOKEN, pageToken);
        }
    }

    public static class DatasetDeleteOption
    extends Option {
        private static final long serialVersionUID = -7166083569900951337L;

        private DatasetDeleteOption(BigQueryRpc.Option option, Object value) {
            super(option, value);
        }

        public static DatasetDeleteOption deleteContents() {
            return new DatasetDeleteOption(BigQueryRpc.Option.DELETE_CONTENTS, true);
        }
    }

    public static class DatasetOption
    extends Option {
        private static final long serialVersionUID = 1674133909259913250L;

        private DatasetOption(BigQueryRpc.Option option, Object value) {
            super(option, value);
        }

        public static DatasetOption fields(DatasetField ... fields) {
            return new DatasetOption(BigQueryRpc.Option.FIELDS, DatasetField.selector(fields));
        }
    }

    public static class DatasetListOption
    extends Option {
        private static final long serialVersionUID = 8660294969063340498L;

        private DatasetListOption(BigQueryRpc.Option option, Object value) {
            super(option, value);
        }

        public static DatasetListOption maxResults(long maxResults) {
            return new DatasetListOption(BigQueryRpc.Option.MAX_RESULTS, maxResults);
        }

        public static DatasetListOption startPageToken(String pageToken) {
            return new DatasetListOption(BigQueryRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static DatasetListOption all() {
            return new DatasetListOption(BigQueryRpc.Option.ALL_DATASETS, true);
        }
    }

    public static enum JobField {
        CONFIGURATION("configuration"),
        ETAG("etag"),
        ID("id"),
        JOB_REFERENCE("jobReference"),
        SELF_LINK("selfLink"),
        STATISTICS("statistics"),
        STATUS("status"),
        USER_EMAIL("user_email");

        private final String selector;

        private JobField(String selector) {
            this.selector = selector;
        }

        public String selector() {
            return this.selector;
        }

        static String selector(JobField ... fields) {
            HashSet fieldStrings = Sets.newHashSetWithExpectedSize((int)(fields.length + 2));
            fieldStrings.add(JOB_REFERENCE.selector());
            fieldStrings.add(CONFIGURATION.selector());
            for (JobField field : fields) {
                fieldStrings.add(field.selector());
            }
            return Joiner.on((char)',').join((Iterable)fieldStrings);
        }
    }

    public static enum TableField {
        CREATION_TIME("creationTime"),
        DESCRIPTION("description"),
        ETAG("etag"),
        EXPIRATION_TIME("expirationTime"),
        EXTERNAL_DATA_CONFIGURATION("externalDataConfiguration"),
        FRIENDLY_NAME("friendlyName"),
        ID("id"),
        LAST_MODIFIED_TIME("lastModifiedTime"),
        LOCATION("location"),
        NUM_BYTES("numBytes"),
        NUM_ROWS("numRows"),
        SCHEMA("schema"),
        SELF_LINK("selfLink"),
        STREAMING_BUFFER("streamingBuffer"),
        TABLE_REFERENCE("tableReference"),
        TYPE("type"),
        VIEW("view");

        private final String selector;

        private TableField(String selector) {
            this.selector = selector;
        }

        public String selector() {
            return this.selector;
        }

        static String selector(TableField ... fields) {
            HashSet fieldStrings = Sets.newHashSetWithExpectedSize((int)(fields.length + 2));
            fieldStrings.add(TABLE_REFERENCE.selector());
            fieldStrings.add(TYPE.selector());
            for (TableField field : fields) {
                fieldStrings.add(field.selector());
            }
            return Joiner.on((char)',').join((Iterable)fieldStrings);
        }
    }

    public static enum DatasetField {
        ACCESS("access"),
        CREATION_TIME("creationTime"),
        DATASET_REFERENCE("datasetReference"),
        DEFAULT_TABLE_EXPIRATION_MS("defaultTableExpirationMsS"),
        DESCRIPTION("description"),
        ETAG("etag"),
        FRIENDLY_NAME("friendlyName"),
        ID("id"),
        LAST_MODIFIED_TIME("lastModifiedTime"),
        LOCATION("location"),
        SELF_LINK("selfLink");

        private final String selector;

        private DatasetField(String selector) {
            this.selector = selector;
        }

        public String selector() {
            return this.selector;
        }

        static String selector(DatasetField ... fields) {
            HashSet fieldStrings = Sets.newHashSetWithExpectedSize((int)(fields.length + 1));
            fieldStrings.add(DATASET_REFERENCE.selector());
            for (DatasetField field : fields) {
                fieldStrings.add(field.selector());
            }
            return Joiner.on((char)',').join((Iterable)fieldStrings);
        }
    }
}

