/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.common.collect.ImmutableSet;
import com.google.gcloud.BaseServiceException;
import com.google.gcloud.RetryHelper;
import com.google.gcloud.bigquery.BigQueryError;
import java.io.IOException;
import java.util.Set;

public class BigQueryException
extends BaseServiceException {
    private static final Set<BaseServiceException.Error> RETRYABLE_ERRORS = ImmutableSet.of((Object)new BaseServiceException.Error(Integer.valueOf(500), null), (Object)new BaseServiceException.Error(Integer.valueOf(502), null), (Object)new BaseServiceException.Error(Integer.valueOf(503), null), (Object)new BaseServiceException.Error(Integer.valueOf(504), null));
    private static final long serialVersionUID = -5006625989225438209L;
    private final BigQueryError error;

    public BigQueryException(int code, String message) {
        this(code, message, null);
    }

    public BigQueryException(int code, String message, BigQueryError error) {
        super(code, message, error != null ? error.reason() : null, true);
        this.error = error;
    }

    public BigQueryException(IOException exception) {
        super(exception, true);
        BigQueryError error = null;
        if (this.reason() != null) {
            error = new BigQueryError(this.reason(), this.location(), this.getMessage(), this.debugInfo());
        }
        this.error = error;
    }

    public BigQueryError error() {
        return this.error;
    }

    protected Set<BaseServiceException.Error> retryableErrors() {
        return RETRYABLE_ERRORS;
    }

    static BaseServiceException translateAndThrow(RetryHelper.RetryHelperException ex) {
        BaseServiceException.translateAndPropagateIfPossible((RetryHelper.RetryHelperException)ex);
        throw new BigQueryException(0, ex.getMessage());
    }
}

