/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gcloud.BaseService;
import com.google.gcloud.ExceptionHandler;
import com.google.gcloud.Page;
import com.google.gcloud.PageImpl;
import com.google.gcloud.RetryHelper;
import com.google.gcloud.RetryParams;
import com.google.gcloud.ServiceOptions;
import com.google.gcloud.bigquery.Acl;
import com.google.gcloud.bigquery.BaseTableInfo;
import com.google.gcloud.bigquery.BigQuery;
import com.google.gcloud.bigquery.BigQueryError;
import com.google.gcloud.bigquery.BigQueryException;
import com.google.gcloud.bigquery.BigQueryOptions;
import com.google.gcloud.bigquery.CopyJobInfo;
import com.google.gcloud.bigquery.DatasetId;
import com.google.gcloud.bigquery.DatasetInfo;
import com.google.gcloud.bigquery.ExtractJobInfo;
import com.google.gcloud.bigquery.FieldValue;
import com.google.gcloud.bigquery.InsertAllRequest;
import com.google.gcloud.bigquery.InsertAllResponse;
import com.google.gcloud.bigquery.JobId;
import com.google.gcloud.bigquery.JobInfo;
import com.google.gcloud.bigquery.LoadConfiguration;
import com.google.gcloud.bigquery.LoadJobInfo;
import com.google.gcloud.bigquery.Option;
import com.google.gcloud.bigquery.QueryJobInfo;
import com.google.gcloud.bigquery.QueryRequest;
import com.google.gcloud.bigquery.QueryResponse;
import com.google.gcloud.bigquery.QueryResult;
import com.google.gcloud.bigquery.Schema;
import com.google.gcloud.bigquery.TableDataWriteChannel;
import com.google.gcloud.bigquery.TableId;
import com.google.gcloud.spi.BigQueryRpc;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

final class BigQueryImpl
extends BaseService<BigQueryOptions>
implements BigQuery {
    private final BigQueryRpc bigQueryRpc;

    BigQueryImpl(BigQueryOptions options) {
        super((ServiceOptions)options);
        this.bigQueryRpc = (BigQueryRpc)options.rpc();
    }

    @Override
    public DatasetInfo create(DatasetInfo dataset, BigQuery.DatasetOption ... options) throws BigQueryException {
        final Dataset datasetPb = this.setProjectId(dataset).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            return DatasetInfo.fromPb((Dataset)RetryHelper.runWithRetries((Callable)new Callable<Dataset>(){

                @Override
                public Dataset call() {
                    return BigQueryImpl.this.bigQueryRpc.create(datasetPb, optionsMap);
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public <T extends BaseTableInfo> T create(T table, BigQuery.TableOption ... options) throws BigQueryException {
        final Table tablePb = this.setProjectId(table).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            return BaseTableInfo.fromPb((Table)RetryHelper.runWithRetries((Callable)new Callable<Table>(){

                @Override
                public Table call() {
                    return BigQueryImpl.this.bigQueryRpc.create(tablePb, optionsMap);
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public <T extends JobInfo> T create(T job, BigQuery.JobOption ... options) throws BigQueryException {
        final Job jobPb = this.setProjectId(job).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            return JobInfo.fromPb((Job)RetryHelper.runWithRetries((Callable)new Callable<Job>(){

                @Override
                public Job call() {
                    return BigQueryImpl.this.bigQueryRpc.create(jobPb, optionsMap);
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public DatasetInfo getDataset(String datasetId, BigQuery.DatasetOption ... options) throws BigQueryException {
        return this.getDataset(DatasetId.of(datasetId), options);
    }

    @Override
    public DatasetInfo getDataset(final DatasetId datasetId, BigQuery.DatasetOption ... options) throws BigQueryException {
        final Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            Dataset answer = (Dataset)RetryHelper.runWithRetries((Callable)new Callable<Dataset>(){

                @Override
                public Dataset call() {
                    return BigQueryImpl.this.bigQueryRpc.getDataset(datasetId.dataset(), optionsMap);
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
            return answer == null ? null : DatasetInfo.fromPb(answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Page<DatasetInfo> listDatasets(BigQuery.DatasetListOption ... options) throws BigQueryException {
        return BigQueryImpl.listDatasets((BigQueryOptions)this.options(), this.optionMap(options));
    }

    private static Page<DatasetInfo> listDatasets(final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            BigQueryRpc.Tuple result = (BigQueryRpc.Tuple)RetryHelper.runWithRetries((Callable)new Callable<BigQueryRpc.Tuple<String, Iterable<Dataset>>>(){

                @Override
                public BigQueryRpc.Tuple<String, Iterable<Dataset>> call() {
                    return ((BigQueryRpc)serviceOptions.rpc()).listDatasets(optionsMap);
                }
            }, (RetryParams)serviceOptions.retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
            String cursor = (String)result.x();
            return new PageImpl((PageImpl.NextPageFetcher)new DatasetPageFetcher(serviceOptions, cursor, optionsMap), cursor, Iterables.transform((Iterable)((Iterable)result.y()), DatasetInfo.FROM_PB_FUNCTION));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public boolean delete(String datasetId, BigQuery.DatasetDeleteOption ... options) throws BigQueryException {
        return this.delete(DatasetId.of(datasetId), options);
    }

    @Override
    public boolean delete(final DatasetId datasetId, BigQuery.DatasetDeleteOption ... options) throws BigQueryException {
        final Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return BigQueryImpl.this.bigQueryRpc.deleteDataset(datasetId.dataset(), optionsMap);
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public boolean delete(String datasetId, String tableId) throws BigQueryException {
        return this.delete(TableId.of(datasetId, tableId));
    }

    @Override
    public boolean delete(final TableId tableId) throws BigQueryException {
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return BigQueryImpl.this.bigQueryRpc.deleteTable(tableId.dataset(), tableId.table());
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public DatasetInfo update(DatasetInfo dataset, BigQuery.DatasetOption ... options) throws BigQueryException {
        final Dataset datasetPb = this.setProjectId(dataset).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            return DatasetInfo.fromPb((Dataset)RetryHelper.runWithRetries((Callable)new Callable<Dataset>(){

                @Override
                public Dataset call() {
                    return BigQueryImpl.this.bigQueryRpc.patch(datasetPb, optionsMap);
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public <T extends BaseTableInfo> T update(T table, BigQuery.TableOption ... options) throws BigQueryException {
        final Table tablePb = this.setProjectId(table).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            return BaseTableInfo.fromPb((Table)RetryHelper.runWithRetries((Callable)new Callable<Table>(){

                @Override
                public Table call() {
                    return BigQueryImpl.this.bigQueryRpc.patch(tablePb, optionsMap);
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public <T extends BaseTableInfo> T getTable(String datasetId, String tableId, BigQuery.TableOption ... options) throws BigQueryException {
        return this.getTable(TableId.of(datasetId, tableId), options);
    }

    @Override
    public <T extends BaseTableInfo> T getTable(final TableId tableId, BigQuery.TableOption ... options) throws BigQueryException {
        final Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            Table answer = (Table)RetryHelper.runWithRetries((Callable)new Callable<Table>(){

                @Override
                public Table call() {
                    return BigQueryImpl.this.bigQueryRpc.getTable(tableId.dataset(), tableId.table(), optionsMap);
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
            return answer == null ? null : (T)BaseTableInfo.fromPb(answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Page<BaseTableInfo> listTables(String datasetId, BigQuery.TableListOption ... options) throws BigQueryException {
        return BigQueryImpl.listTables(datasetId, (BigQueryOptions)this.options(), this.optionMap(options));
    }

    @Override
    public Page<BaseTableInfo> listTables(DatasetId datasetId, BigQuery.TableListOption ... options) throws BigQueryException {
        return BigQueryImpl.listTables(datasetId.dataset(), (BigQueryOptions)this.options(), this.optionMap(options));
    }

    private static Page<BaseTableInfo> listTables(final String datasetId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            BigQueryRpc.Tuple result = (BigQueryRpc.Tuple)RetryHelper.runWithRetries((Callable)new Callable<BigQueryRpc.Tuple<String, Iterable<Table>>>(){

                @Override
                public BigQueryRpc.Tuple<String, Iterable<Table>> call() {
                    return ((BigQueryRpc)serviceOptions.rpc()).listTables(datasetId, optionsMap);
                }
            }, (RetryParams)serviceOptions.retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
            String cursor = (String)result.x();
            Iterable tables = Iterables.transform((Iterable)((Iterable)result.y()), BaseTableInfo.FROM_PB_FUNCTION);
            return new PageImpl((PageImpl.NextPageFetcher)new TablePageFetcher(datasetId, serviceOptions, cursor, optionsMap), cursor, tables);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public InsertAllResponse insertAll(InsertAllRequest request) throws BigQueryException {
        TableId tableId = request.table();
        TableDataInsertAllRequest requestPb = new TableDataInsertAllRequest();
        requestPb.setIgnoreUnknownValues(request.ignoreUnknownValues());
        requestPb.setSkipInvalidRows(request.skipInvalidRows());
        requestPb.setTemplateSuffix(request.templateSuffix());
        List rowsPb = Lists.transform(request.rows(), (Function)new Function<InsertAllRequest.RowToInsert, TableDataInsertAllRequest.Rows>(){

            public TableDataInsertAllRequest.Rows apply(InsertAllRequest.RowToInsert rowToInsert) {
                return new TableDataInsertAllRequest.Rows().setInsertId(rowToInsert.id()).setJson(rowToInsert.content());
            }
        });
        requestPb.setRows(rowsPb);
        return InsertAllResponse.fromPb(this.bigQueryRpc.insertAll(tableId.dataset(), tableId.table(), requestPb));
    }

    @Override
    public Page<List<FieldValue>> listTableData(String datasetId, String tableId, BigQuery.TableDataListOption ... options) throws BigQueryException {
        return BigQueryImpl.listTableData(TableId.of(datasetId, tableId), (BigQueryOptions)this.options(), this.optionMap(options));
    }

    @Override
    public Page<List<FieldValue>> listTableData(TableId tableId, BigQuery.TableDataListOption ... options) throws BigQueryException {
        return BigQueryImpl.listTableData(tableId, (BigQueryOptions)this.options(), this.optionMap(options));
    }

    private static Page<List<FieldValue>> listTableData(final TableId tableId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            BigQueryRpc.Tuple result = (BigQueryRpc.Tuple)RetryHelper.runWithRetries((Callable)new Callable<BigQueryRpc.Tuple<String, Iterable<TableRow>>>(){

                @Override
                public BigQueryRpc.Tuple<String, Iterable<TableRow>> call() {
                    return ((BigQueryRpc)serviceOptions.rpc()).listTableData(tableId.dataset(), tableId.table(), optionsMap);
                }
            }, (RetryParams)serviceOptions.retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
            String cursor = (String)result.x();
            return new PageImpl((PageImpl.NextPageFetcher)new TableDataPageFetcher(tableId, serviceOptions, cursor, optionsMap), cursor, BigQueryImpl.transformTableData((Iterable)result.y()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    private static List<List<FieldValue>> transformTableData(Iterable<TableRow> tableDataPb) {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)(tableDataPb != null ? tableDataPb : ImmutableList.of()), (Function)new Function<TableRow, List<FieldValue>>(){

            public List<FieldValue> apply(TableRow rowPb) {
                return Lists.transform((List)rowPb.getF(), FieldValue.FROM_PB_FUNCTION);
            }
        }));
    }

    @Override
    public <T extends JobInfo> T getJob(String jobId, BigQuery.JobOption ... options) throws BigQueryException {
        return this.getJob(JobId.of(jobId), options);
    }

    @Override
    public <T extends JobInfo> T getJob(final JobId jobId, BigQuery.JobOption ... options) throws BigQueryException {
        final Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            Job answer = (Job)RetryHelper.runWithRetries((Callable)new Callable<Job>(){

                @Override
                public Job call() {
                    return BigQueryImpl.this.bigQueryRpc.getJob(jobId.job(), optionsMap);
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
            return answer == null ? null : (T)JobInfo.fromPb(answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public Page<JobInfo> listJobs(BigQuery.JobListOption ... options) throws BigQueryException {
        return BigQueryImpl.listJobs((BigQueryOptions)this.options(), this.optionMap(options));
    }

    private static Page<JobInfo> listJobs(final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        BigQueryRpc.Tuple result = (BigQueryRpc.Tuple)RetryHelper.runWithRetries((Callable)new Callable<BigQueryRpc.Tuple<String, Iterable<Job>>>(){

            @Override
            public BigQueryRpc.Tuple<String, Iterable<Job>> call() {
                return ((BigQueryRpc)serviceOptions.rpc()).listJobs(optionsMap);
            }
        }, (RetryParams)serviceOptions.retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
        String cursor = (String)result.x();
        Iterable jobs = Iterables.transform((Iterable)((Iterable)result.y()), JobInfo.FROM_PB_FUNCTION);
        return new PageImpl((PageImpl.NextPageFetcher)new JobPageFetcher(serviceOptions, cursor, optionsMap), cursor, jobs);
    }

    @Override
    public boolean cancel(String jobId) throws BigQueryException {
        return this.cancel(JobId.of(jobId));
    }

    @Override
    public boolean cancel(final JobId jobId) throws BigQueryException {
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return BigQueryImpl.this.bigQueryRpc.cancel(jobId.job());
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public QueryResponse query(final QueryRequest request) throws BigQueryException {
        try {
            com.google.api.services.bigquery.model.QueryResponse results = (com.google.api.services.bigquery.model.QueryResponse)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.bigquery.model.QueryResponse>(){

                @Override
                public com.google.api.services.bigquery.model.QueryResponse call() {
                    return BigQueryImpl.this.bigQueryRpc.query(BigQueryImpl.this.setProjectId(request).toPb());
                }
            }, (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
            QueryResponse.Builder builder = QueryResponse.builder();
            JobId completeJobId = JobId.fromPb(results.getJobReference());
            builder.jobId(completeJobId);
            builder.jobCompleted(results.getJobComplete());
            List rowsPb = results.getRows();
            if (results.getJobComplete().booleanValue()) {
                builder.jobCompleted(true);
                QueryResult.Builder resultBuilder = BigQueryImpl.transformQueryResults(completeJobId, rowsPb, results.getPageToken(), (BigQueryOptions)this.options(), ImmutableMap.of());
                resultBuilder.totalBytesProcessed(results.getTotalBytesProcessed());
                resultBuilder.cacheHit(results.getCacheHit());
                if (results.getSchema() != null) {
                    resultBuilder.schema(Schema.fromPb(results.getSchema()));
                }
                if (results.getTotalRows() != null) {
                    resultBuilder.totalRows(results.getTotalRows().longValue());
                }
                builder.result(resultBuilder.build());
            }
            if (results.getErrors() != null) {
                builder.executionErrors(Lists.transform((List)results.getErrors(), BigQueryError.FROM_PB_FUNCTION));
            }
            return builder.build();
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public QueryResponse getQueryResults(JobId job, BigQuery.QueryResultsOption ... options) throws BigQueryException {
        Map<BigQueryRpc.Option, ?> optionsMap = this.optionMap(options);
        return BigQueryImpl.getQueryResults(job, (BigQueryOptions)this.options(), optionsMap);
    }

    private static QueryResponse getQueryResults(final JobId jobId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            GetQueryResultsResponse results = (GetQueryResultsResponse)RetryHelper.runWithRetries((Callable)new Callable<GetQueryResultsResponse>(){

                @Override
                public GetQueryResultsResponse call() {
                    return ((BigQueryRpc)serviceOptions.rpc()).getQueryResults(jobId.job(), optionsMap);
                }
            }, (RetryParams)serviceOptions.retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
            QueryResponse.Builder builder = QueryResponse.builder();
            JobId completeJobId = JobId.fromPb(results.getJobReference());
            builder.jobId(completeJobId);
            builder.etag(results.getEtag());
            builder.jobCompleted(results.getJobComplete());
            List rowsPb = results.getRows();
            if (results.getJobComplete().booleanValue()) {
                QueryResult.Builder resultBuilder = BigQueryImpl.transformQueryResults(completeJobId, rowsPb, results.getPageToken(), serviceOptions, ImmutableMap.of());
                resultBuilder.totalBytesProcessed(results.getTotalBytesProcessed());
                resultBuilder.cacheHit(results.getCacheHit());
                if (results.getSchema() != null) {
                    resultBuilder.schema(Schema.fromPb(results.getSchema()));
                }
                if (results.getTotalRows() != null) {
                    resultBuilder.totalRows(results.getTotalRows().longValue());
                }
                builder.result(resultBuilder.build());
            }
            if (results.getErrors() != null) {
                builder.executionErrors(Lists.transform((List)results.getErrors(), BigQueryError.FROM_PB_FUNCTION));
            }
            return builder.build();
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    private static QueryResult.Builder transformQueryResults(JobId jobId, List<TableRow> rowsPb, String cursor, BigQueryOptions serviceOptions, Map<BigQueryRpc.Option, ?> optionsMap) {
        QueryResultsPageFetcherImpl nextPageFetcher = new QueryResultsPageFetcherImpl(jobId, serviceOptions, cursor, optionsMap);
        return QueryResult.builder().pageFetcher(nextPageFetcher).cursor(cursor).results(BigQueryImpl.transformTableData(rowsPb));
    }

    @Override
    public TableDataWriteChannel writer(LoadConfiguration loadConfiguration) {
        return new TableDataWriteChannel((BigQueryOptions)this.options(), this.setProjectId(loadConfiguration));
    }

    private Map<BigQueryRpc.Option, ?> optionMap(Option ... options) {
        EnumMap optionMap = Maps.newEnumMap(BigQueryRpc.Option.class);
        for (Option option : options) {
            Object prev = optionMap.put(option.rpcOption(), option.value());
            Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Duplicate option %s", (Object[])new Object[]{option});
        }
        return optionMap;
    }

    private DatasetInfo setProjectId(DatasetInfo dataset) {
        DatasetInfo.Builder datasetBuilder = dataset.toBuilder();
        datasetBuilder.datasetId(this.setProjectId(dataset.datasetId()));
        if (dataset.acl() != null) {
            ArrayList acls = Lists.newArrayListWithCapacity((int)dataset.acl().size());
            for (Acl acl : dataset.acl()) {
                if (acl.entity().type() == Acl.Entity.Type.VIEW) {
                    Dataset.Access accessPb = acl.toPb();
                    TableReference viewReferencePb = accessPb.getView();
                    if (viewReferencePb.getProjectId() == null) {
                        viewReferencePb.setProjectId(((BigQueryOptions)this.options()).projectId());
                    }
                    acls.add(Acl.of(new Acl.View(TableId.fromPb(viewReferencePb))));
                    continue;
                }
                acls.add(acl);
            }
            datasetBuilder.acl(acls);
        }
        return datasetBuilder.build();
    }

    private DatasetId setProjectId(DatasetId dataset) {
        return dataset.project() != null ? dataset : DatasetId.of(((BigQueryOptions)this.options()).projectId(), dataset.dataset());
    }

    private BaseTableInfo setProjectId(BaseTableInfo table) {
        return ((BaseTableInfo.Builder)table.toBuilder().tableId(this.setProjectId(table.tableId()))).build();
    }

    private TableId setProjectId(TableId table) {
        return table.project() != null ? table : TableId.of(((BigQueryOptions)this.options()).projectId(), table.dataset(), table.table());
    }

    private JobInfo setProjectId(JobInfo job) {
        if (job instanceof CopyJobInfo) {
            CopyJobInfo copyJob = (CopyJobInfo)job;
            CopyJobInfo.Builder copyBuilder = copyJob.toBuilder();
            copyBuilder.destinationTable(this.setProjectId(copyJob.destinationTable()));
            copyBuilder.sourceTables(Lists.transform(copyJob.sourceTables(), (Function)new Function<TableId, TableId>(){

                public TableId apply(TableId tableId) {
                    return BigQueryImpl.this.setProjectId(tableId);
                }
            }));
            return copyBuilder.build();
        }
        if (job instanceof QueryJobInfo) {
            QueryJobInfo queryJob = (QueryJobInfo)job;
            QueryJobInfo.Builder queryBuilder = queryJob.toBuilder();
            if (queryJob.destinationTable() != null) {
                queryBuilder.destinationTable(this.setProjectId(queryJob.destinationTable()));
            }
            if (queryJob.defaultDataset() != null) {
                queryBuilder.defaultDataset(this.setProjectId(queryJob.defaultDataset()));
            }
            return queryBuilder.build();
        }
        if (job instanceof ExtractJobInfo) {
            ExtractJobInfo extractJob = (ExtractJobInfo)job;
            ExtractJobInfo.Builder extractBuilder = extractJob.toBuilder();
            extractBuilder.sourceTable(this.setProjectId(extractJob.sourceTable()));
            return extractBuilder.build();
        }
        if (job instanceof LoadJobInfo) {
            LoadJobInfo loadJob = (LoadJobInfo)job;
            LoadJobInfo.Builder loadBuilder = loadJob.toBuilder();
            return loadBuilder.configuration(this.setProjectId(loadJob.configuration())).build();
        }
        return job;
    }

    private QueryRequest setProjectId(QueryRequest request) {
        QueryRequest.Builder builder = request.toBuilder();
        if (request.defaultDataset() != null) {
            builder.defaultDataset(this.setProjectId(request.defaultDataset()));
        }
        return builder.build();
    }

    private LoadConfiguration setProjectId(LoadConfiguration configuration) {
        LoadConfiguration.Builder builder = configuration.toBuilder();
        builder.destinationTable(this.setProjectId(configuration.destinationTable()));
        return builder.build();
    }

    private static class QueryResultsPageFetcherImpl
    implements PageImpl.NextPageFetcher<List<FieldValue>>,
    QueryResult.QueryResultsPageFetcher {
        private static final long serialVersionUID = -9198905840550459803L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final JobId job;

        QueryResultsPageFetcherImpl(JobId job, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.job = job;
        }

        @Override
        public QueryResult nextPage() {
            return BigQueryImpl.getQueryResults(this.job, this.serviceOptions, this.requestOptions).result();
        }
    }

    private static class TableDataPageFetcher
    implements PageImpl.NextPageFetcher<List<FieldValue>> {
        private static final long serialVersionUID = -8501991114794410114L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final TableId table;

        TableDataPageFetcher(TableId table, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.table = table;
        }

        public Page<List<FieldValue>> nextPage() {
            return BigQueryImpl.listTableData(this.table, this.serviceOptions, this.requestOptions);
        }
    }

    private static class JobPageFetcher
    implements PageImpl.NextPageFetcher<JobInfo> {
        private static final long serialVersionUID = 8536533282558245472L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;

        JobPageFetcher(BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<JobInfo> nextPage() {
            return BigQueryImpl.listJobs(this.serviceOptions, this.requestOptions);
        }
    }

    private static class TablePageFetcher
    implements PageImpl.NextPageFetcher<BaseTableInfo> {
        private static final long serialVersionUID = 8611248840504201187L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final String dataset;

        TablePageFetcher(String dataset, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.dataset = dataset;
        }

        public Page<BaseTableInfo> nextPage() {
            return BigQueryImpl.listTables(this.dataset, this.serviceOptions, this.requestOptions);
        }
    }

    private static class DatasetPageFetcher
    implements PageImpl.NextPageFetcher<DatasetInfo> {
        private static final long serialVersionUID = -3057564042439021278L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;

        DatasetPageFetcher(BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)BigQueryRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<DatasetInfo> nextPage() {
            return BigQueryImpl.listDatasets(this.serviceOptions, this.requestOptions);
        }
    }
}

