/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.common.collect.ImmutableSet;
import com.google.gcloud.ServiceOptions;
import com.google.gcloud.bigquery.BigQuery;
import com.google.gcloud.bigquery.BigQueryFactory;
import com.google.gcloud.bigquery.BigQueryImpl;
import com.google.gcloud.spi.BigQueryRpc;
import com.google.gcloud.spi.BigQueryRpcFactory;
import com.google.gcloud.spi.DefaultBigQueryRpc;
import java.util.Set;

public class BigQueryOptions
extends ServiceOptions<BigQuery, BigQueryRpc, BigQueryOptions> {
    private static final String BIGQUERY_SCOPE = "https://www.googleapis.com/auth/bigquery";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/bigquery");
    private static final long serialVersionUID = -215981591481708043L;

    private BigQueryOptions(Builder builder) {
        super(BigQueryFactory.class, BigQueryRpcFactory.class, (ServiceOptions.Builder)builder);
    }

    protected BigQueryFactory defaultServiceFactory() {
        return DefaultBigqueryFactory.INSTANCE;
    }

    protected BigQueryRpcFactory defaultRpcFactory() {
        return DefaultBigQueryRpcFactory.INSTANCE;
    }

    protected Set<String> scopes() {
        return SCOPES;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BigQueryOptions)) {
            return false;
        }
        BigQueryOptions other = (BigQueryOptions)((Object)obj);
        return this.baseEquals(other);
    }

    public static BigQueryOptions defaultInstance() {
        return BigQueryOptions.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ServiceOptions.Builder<BigQuery, BigQueryRpc, BigQueryOptions, Builder> {
        private Builder() {
        }

        private Builder(BigQueryOptions options) {
            super((ServiceOptions)options);
        }

        public BigQueryOptions build() {
            return new BigQueryOptions(this);
        }
    }

    public static class DefaultBigQueryRpcFactory
    implements BigQueryRpcFactory {
        private static final BigQueryRpcFactory INSTANCE = new DefaultBigQueryRpcFactory();

        public BigQueryRpc create(BigQueryOptions options) {
            return new DefaultBigQueryRpc(options);
        }
    }

    public static class DefaultBigqueryFactory
    implements BigQueryFactory {
        private static final BigQueryFactory INSTANCE = new DefaultBigqueryFactory();

        public BigQuery create(BigQueryOptions options) {
            return new BigQueryImpl(options);
        }
    }
}

