/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gcloud.bigquery.JobId;
import com.google.gcloud.bigquery.JobInfo;
import com.google.gcloud.bigquery.JobStatistics;
import com.google.gcloud.bigquery.TableId;
import java.util.List;
import java.util.Objects;

public class CopyJobInfo
extends JobInfo<JobStatistics> {
    private static final long serialVersionUID = 7830335512951916299L;
    private final List<TableId> sourceTables;
    private final TableId destinationTable;
    private final JobInfo.CreateDisposition createDisposition;
    private final JobInfo.WriteDisposition writeDisposition;

    private CopyJobInfo(Builder builder) {
        super(builder);
        this.sourceTables = (List)Preconditions.checkNotNull((Object)builder.sourceTables);
        this.destinationTable = (TableId)Preconditions.checkNotNull((Object)builder.destinationTable);
        this.createDisposition = builder.createDisposition;
        this.writeDisposition = builder.writeDisposition;
    }

    public List<TableId> sourceTables() {
        return this.sourceTables;
    }

    public TableId destinationTable() {
        return this.destinationTable;
    }

    public JobInfo.CreateDisposition createDisposition() {
        return this.createDisposition;
    }

    public JobInfo.WriteDisposition writeDisposition() {
        return this.writeDisposition;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("sourceTables", this.sourceTables).add("destinationTable", (Object)this.destinationTable).add("createDisposition", (Object)this.createDisposition).add("writeDisposition", (Object)this.writeDisposition);
    }

    public boolean equals(Object obj) {
        return obj instanceof CopyJobInfo && this.baseEquals((CopyJobInfo)obj);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseHashCode(), this.sourceTables, this.destinationTable, this.createDisposition, this.writeDisposition});
    }

    @Override
    Job toPb() {
        JobConfigurationTableCopy copyConfigurationPb = new JobConfigurationTableCopy();
        copyConfigurationPb.setDestinationTable(this.destinationTable.toPb());
        if (this.sourceTables.size() == 1) {
            copyConfigurationPb.setSourceTable(this.sourceTables.get(0).toPb());
        } else {
            copyConfigurationPb.setSourceTables(Lists.transform(this.sourceTables, TableId.TO_PB_FUNCTION));
        }
        if (this.createDisposition != null) {
            copyConfigurationPb.setCreateDisposition(this.createDisposition.toString());
        }
        if (this.writeDisposition != null) {
            copyConfigurationPb.setWriteDisposition(this.writeDisposition.toString());
        }
        return super.toPb().setConfiguration(new JobConfiguration().setCopy(copyConfigurationPb));
    }

    public static Builder builder(TableId destinationTable, TableId sourceTable) {
        return CopyJobInfo.builder(destinationTable, (List<TableId>)ImmutableList.of((Object)Preconditions.checkNotNull((Object)sourceTable)));
    }

    public static Builder builder(TableId destinationTable, List<TableId> sourceTables) {
        return new Builder().destinationTable(destinationTable).sourceTables(sourceTables);
    }

    public static CopyJobInfo of(TableId destinationTable, TableId sourceTable) {
        return CopyJobInfo.builder(destinationTable, sourceTable).build();
    }

    public static CopyJobInfo of(TableId destinationTable, List<TableId> sourceTables) {
        return CopyJobInfo.builder(destinationTable, sourceTables).build();
    }

    public static CopyJobInfo of(JobId jobId, TableId destinationTable, TableId sourceTable) {
        return ((Builder)CopyJobInfo.builder(destinationTable, sourceTable).jobId(jobId)).build();
    }

    public static CopyJobInfo of(JobId jobId, TableId destinationTable, List<TableId> sourceTables) {
        return ((Builder)CopyJobInfo.builder(destinationTable, sourceTables).jobId(jobId)).build();
    }

    static CopyJobInfo fromPb(Job jobPb) {
        return new Builder(jobPb).build();
    }

    public static final class Builder
    extends JobInfo.Builder<CopyJobInfo, JobStatistics, Builder> {
        private List<TableId> sourceTables;
        private TableId destinationTable;
        private JobInfo.CreateDisposition createDisposition;
        private JobInfo.WriteDisposition writeDisposition;

        private Builder() {
        }

        private Builder(CopyJobInfo jobInfo) {
            super(jobInfo);
            this.sourceTables = jobInfo.sourceTables;
            this.destinationTable = jobInfo.destinationTable;
            this.createDisposition = jobInfo.createDisposition;
            this.writeDisposition = jobInfo.writeDisposition;
        }

        private Builder(Job jobPb) {
            super(jobPb);
            JobConfigurationTableCopy copyConfigurationPb = jobPb.getConfiguration().getCopy();
            this.destinationTable = TableId.fromPb(copyConfigurationPb.getDestinationTable());
            this.sourceTables = copyConfigurationPb.getSourceTables() != null ? Lists.transform((List)copyConfigurationPb.getSourceTables(), TableId.FROM_PB_FUNCTION) : ImmutableList.of((Object)TableId.fromPb(copyConfigurationPb.getSourceTable()));
            if (copyConfigurationPb.getCreateDisposition() != null) {
                this.createDisposition = JobInfo.CreateDisposition.valueOf(copyConfigurationPb.getCreateDisposition());
            }
            if (copyConfigurationPb.getWriteDisposition() != null) {
                this.writeDisposition = JobInfo.WriteDisposition.valueOf(copyConfigurationPb.getWriteDisposition());
            }
        }

        public Builder sourceTables(List<TableId> sourceTables) {
            this.sourceTables = sourceTables != null ? ImmutableList.copyOf(sourceTables) : null;
            return (Builder)this.self();
        }

        public Builder destinationTable(TableId destinationTable) {
            this.destinationTable = destinationTable;
            return (Builder)this.self();
        }

        public Builder createDisposition(JobInfo.CreateDisposition createDisposition) {
            this.createDisposition = createDisposition;
            return (Builder)this.self();
        }

        public Builder writeDisposition(JobInfo.WriteDisposition writeDisposition) {
            this.writeDisposition = writeDisposition;
            return (Builder)this.self();
        }

        @Override
        public CopyJobInfo build() {
            return new CopyJobInfo(this);
        }
    }
}

