/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.common.base.MoreObjects;
import com.google.gcloud.bigquery.FormatOptions;
import java.nio.charset.Charset;
import java.util.Objects;

public class CsvOptions
extends FormatOptions {
    private static final long serialVersionUID = 2193570529308612708L;
    private final Boolean allowJaggedRows;
    private final Boolean allowQuotedNewLines;
    private final String encoding;
    private final String fieldDelimiter;
    private final String quote;
    private final Integer skipLeadingRows;

    private CsvOptions(Builder builder) {
        super("CSV");
        this.allowJaggedRows = builder.allowJaggedRows;
        this.allowQuotedNewLines = builder.allowQuotedNewLines;
        this.encoding = builder.encoding;
        this.fieldDelimiter = builder.fieldDelimiter;
        this.quote = builder.quote;
        this.skipLeadingRows = builder.skipLeadingRows;
    }

    public Boolean allowJaggedRows() {
        return this.allowJaggedRows;
    }

    public Boolean allowQuotedNewLines() {
        return this.allowQuotedNewLines;
    }

    public String encoding() {
        return this.encoding;
    }

    public String fieldDelimiter() {
        return this.fieldDelimiter;
    }

    public String quote() {
        return this.quote;
    }

    public Integer skipLeadingRows() {
        return this.skipLeadingRows;
    }

    public Builder toBuilder() {
        return new Builder().allowJaggedRows(this.allowJaggedRows).allowQuotedNewLines(this.allowQuotedNewLines).encoding(this.encoding).fieldDelimiter(this.fieldDelimiter).quote(this.quote).skipLeadingRows(this.skipLeadingRows);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type()).add("allowJaggedRows", (Object)this.allowJaggedRows).add("allowQuotedNewLines", (Object)this.allowQuotedNewLines).add("encoding", (Object)this.encoding).add("fieldDelimiter", (Object)this.fieldDelimiter).add("quote", (Object)this.quote).add("skipLeadingRows", (Object)this.skipLeadingRows).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type(), this.allowJaggedRows, this.allowQuotedNewLines, this.encoding, this.fieldDelimiter, this.quote, this.skipLeadingRows);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CsvOptions && Objects.equals(this.toPb(), ((CsvOptions)obj).toPb());
    }

    com.google.api.services.bigquery.model.CsvOptions toPb() {
        com.google.api.services.bigquery.model.CsvOptions csvOptions = new com.google.api.services.bigquery.model.CsvOptions();
        csvOptions.setAllowJaggedRows(this.allowJaggedRows);
        csvOptions.setAllowQuotedNewlines(this.allowQuotedNewLines);
        csvOptions.setEncoding(this.encoding);
        csvOptions.setFieldDelimiter(this.fieldDelimiter);
        csvOptions.setQuote(this.quote);
        csvOptions.setSkipLeadingRows(this.skipLeadingRows);
        return csvOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    static CsvOptions fromPb(com.google.api.services.bigquery.model.CsvOptions csvOptions) {
        Builder builder = CsvOptions.builder();
        if (csvOptions.getAllowJaggedRows() != null) {
            builder.allowJaggedRows(csvOptions.getAllowJaggedRows());
        }
        if (csvOptions.getAllowQuotedNewlines() != null) {
            builder.allowQuotedNewLines(csvOptions.getAllowQuotedNewlines());
        }
        if (csvOptions.getEncoding() != null) {
            builder.encoding(csvOptions.getEncoding());
        }
        if (csvOptions.getFieldDelimiter() != null) {
            builder.fieldDelimiter(csvOptions.getFieldDelimiter());
        }
        if (csvOptions.getQuote() != null) {
            builder.quote(csvOptions.getQuote());
        }
        if (csvOptions.getSkipLeadingRows() != null) {
            builder.skipLeadingRows(csvOptions.getSkipLeadingRows());
        }
        return builder.build();
    }

    public static final class Builder {
        private Boolean allowJaggedRows;
        private Boolean allowQuotedNewLines;
        private String encoding;
        private String fieldDelimiter;
        private String quote;
        private Integer skipLeadingRows;

        private Builder() {
        }

        public Builder allowJaggedRows(Boolean allowJaggedRows) {
            this.allowJaggedRows = allowJaggedRows;
            return this;
        }

        public Builder allowQuotedNewLines(Boolean allowQuotedNewLines) {
            this.allowQuotedNewLines = allowQuotedNewLines;
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder encoding(Charset encoding) {
            this.encoding = encoding.name();
            return this;
        }

        public Builder fieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        public Builder quote(String quote) {
            this.quote = quote;
            return this;
        }

        public Builder skipLeadingRows(Integer skipLeadingRows) {
            this.skipLeadingRows = skipLeadingRows;
            return this;
        }

        public CsvOptions build() {
            return new CsvOptions(this);
        }
    }
}

