/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.gcloud.Page;
import com.google.gcloud.PageImpl;
import com.google.gcloud.bigquery.BaseTableInfo;
import com.google.gcloud.bigquery.BigQuery;
import com.google.gcloud.bigquery.BigQueryOptions;
import com.google.gcloud.bigquery.DatasetInfo;
import com.google.gcloud.bigquery.ExternalDataConfiguration;
import com.google.gcloud.bigquery.ExternalTableInfo;
import com.google.gcloud.bigquery.Schema;
import com.google.gcloud.bigquery.Table;
import com.google.gcloud.bigquery.TableId;
import com.google.gcloud.bigquery.TableInfo;
import com.google.gcloud.bigquery.UserDefinedFunction;
import com.google.gcloud.bigquery.ViewInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class Dataset {
    private final BigQuery bigquery;
    private final DatasetInfo info;

    public Dataset(BigQuery bigquery, DatasetInfo info) {
        this.bigquery = (BigQuery)Preconditions.checkNotNull((Object)bigquery);
        this.info = (DatasetInfo)Preconditions.checkNotNull((Object)info);
    }

    public static Dataset get(BigQuery bigquery, String dataset, BigQuery.DatasetOption ... options) {
        DatasetInfo info = bigquery.getDataset(dataset, options);
        return info != null ? new Dataset(bigquery, info) : null;
    }

    public DatasetInfo info() {
        return this.info;
    }

    public boolean exists() {
        return this.bigquery.getDataset(this.info.datasetId(), BigQuery.DatasetOption.fields(new BigQuery.DatasetField[0])) != null;
    }

    public Dataset reload(BigQuery.DatasetOption ... options) {
        return Dataset.get(this.bigquery, this.info.datasetId().dataset(), options);
    }

    public Dataset update(DatasetInfo datasetInfo, BigQuery.DatasetOption ... options) {
        Preconditions.checkArgument((boolean)Objects.equals(datasetInfo.datasetId().dataset(), this.info.datasetId().dataset()), (Object)"Dataset's user-defined ids must match");
        return new Dataset(this.bigquery, this.bigquery.update(datasetInfo, options));
    }

    public boolean delete() {
        return this.bigquery.delete(this.info.datasetId(), new BigQuery.DatasetDeleteOption[0]);
    }

    public Page<Table> list(BigQuery.TableListOption ... options) {
        Page<BaseTableInfo> infoPage = this.bigquery.listTables(this.info.datasetId(), options);
        BigQueryOptions bigqueryOptions = (BigQueryOptions)this.bigquery.options();
        return new PageImpl((PageImpl.NextPageFetcher)new TablePageFetcher(bigqueryOptions, infoPage), infoPage.nextPageCursor(), (Iterable)new LazyTableIterable(bigqueryOptions, infoPage.values()));
    }

    public Table get(String table, BigQuery.TableOption ... options) {
        Object tableInfo = this.bigquery.getTable(TableId.of(this.info.datasetId().dataset(), table), options);
        return tableInfo != null ? new Table(this.bigquery, (BaseTableInfo)tableInfo) : null;
    }

    public Table create(String table, Schema schema, BigQuery.TableOption ... options) {
        TableInfo tableInfo = TableInfo.of(TableId.of(this.info.datasetId().dataset(), table), schema);
        return new Table(this.bigquery, this.bigquery.create(tableInfo, options));
    }

    public Table create(String table, String query, List<UserDefinedFunction> functions, BigQuery.TableOption ... options) {
        ViewInfo tableInfo = ViewInfo.of(TableId.of(this.info.datasetId().dataset(), table), query, functions);
        return new Table(this.bigquery, this.bigquery.create(tableInfo, options));
    }

    public Table create(String table, String query, BigQuery.TableOption ... options) {
        ViewInfo tableInfo = ViewInfo.of(TableId.of(this.info.datasetId().dataset(), table), query);
        return new Table(this.bigquery, this.bigquery.create(tableInfo, options));
    }

    public Table create(String table, ExternalDataConfiguration configuration, BigQuery.TableOption ... options) {
        ExternalTableInfo tableInfo = ExternalTableInfo.of(TableId.of(this.info.datasetId().dataset(), table), configuration);
        return new Table(this.bigquery, this.bigquery.create(tableInfo, options));
    }

    public BigQuery bigquery() {
        return this.bigquery;
    }

    private static class LazyTableIterable
    implements Iterable<Table>,
    Serializable {
        private static final long serialVersionUID = 3312744215731674032L;
        private final BigQueryOptions options;
        private final Iterable<BaseTableInfo> infoIterable;
        private transient BigQuery bigquery;

        public LazyTableIterable(BigQueryOptions options, Iterable<BaseTableInfo> infoIterable) {
            this.options = options;
            this.infoIterable = infoIterable;
            this.bigquery = (BigQuery)options.service();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.bigquery = (BigQuery)this.options.service();
        }

        @Override
        public Iterator<Table> iterator() {
            return Iterators.transform(this.infoIterable.iterator(), (Function)new Function<BaseTableInfo, Table>(){

                public Table apply(BaseTableInfo tableInfo) {
                    return new Table(LazyTableIterable.this.bigquery, tableInfo);
                }
            });
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.options, this.infoIterable});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LazyTableIterable)) {
                return false;
            }
            LazyTableIterable other = (LazyTableIterable)obj;
            return Objects.equals((Object)this.options, (Object)other.options) && Objects.equals(this.infoIterable, other.infoIterable);
        }
    }

    private static class TablePageFetcher
    implements PageImpl.NextPageFetcher<Table> {
        private static final long serialVersionUID = 6906197848579250598L;
        private final BigQueryOptions options;
        private final Page<BaseTableInfo> infoPage;

        TablePageFetcher(BigQueryOptions options, Page<BaseTableInfo> infoPage) {
            this.options = options;
            this.infoPage = infoPage;
        }

        public Page<Table> nextPage() {
            Page nextInfoPage = this.infoPage.nextPage();
            return new PageImpl((PageImpl.NextPageFetcher)new TablePageFetcher(this.options, (Page<BaseTableInfo>)nextInfoPage), nextInfoPage.nextPageCursor(), (Iterable)new LazyTableIterable(this.options, nextInfoPage.values()));
        }
    }
}

