/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.api.client.util.Data;
import com.google.api.services.bigquery.model.Dataset;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gcloud.bigquery.Acl;
import com.google.gcloud.bigquery.DatasetId;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public final class DatasetInfo
implements Serializable {
    static final Function<Dataset, DatasetInfo> FROM_PB_FUNCTION = new Function<Dataset, DatasetInfo>(){

        public DatasetInfo apply(Dataset pb) {
            return DatasetInfo.fromPb(pb);
        }
    };
    static final Function<DatasetInfo, Dataset> TO_PB_FUNCTION = new Function<DatasetInfo, Dataset>(){

        public Dataset apply(DatasetInfo datasetInfo) {
            return datasetInfo.toPb();
        }
    };
    private static final long serialVersionUID = -6615133444520365839L;
    private final DatasetId datasetId;
    private final List<Acl> acl;
    private final Long creationTime;
    private final Long defaultTableLifetime;
    private final String description;
    private final String etag;
    private final String friendlyName;
    private final String id;
    private final Long lastModified;
    private final String location;
    private final String selfLink;

    private DatasetInfo(Builder builder) {
        this.datasetId = (DatasetId)Preconditions.checkNotNull((Object)builder.datasetId);
        this.acl = builder.acl;
        this.creationTime = builder.creationTime;
        this.defaultTableLifetime = builder.defaultTableLifetime;
        this.description = builder.description;
        this.etag = builder.etag;
        this.friendlyName = builder.friendlyName;
        this.id = builder.id;
        this.lastModified = builder.lastModified;
        this.location = builder.location;
        this.selfLink = builder.selfLink;
    }

    public DatasetId datasetId() {
        return this.datasetId;
    }

    public List<Acl> acl() {
        return this.acl;
    }

    public Long creationTime() {
        return this.creationTime;
    }

    public Long defaultTableLifetime() {
        return this.defaultTableLifetime;
    }

    public String description() {
        return this.description;
    }

    public String etag() {
        return this.etag;
    }

    public String friendlyName() {
        return this.friendlyName;
    }

    public String id() {
        return this.id;
    }

    public Long lastModified() {
        return this.lastModified;
    }

    public String location() {
        return this.location;
    }

    public String selfLink() {
        return this.selfLink;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("datasetId", (Object)this.datasetId).add("creationTime", (Object)this.creationTime).add("defaultTableLifetime", (Object)this.defaultTableLifetime).add("description", (Object)this.description).add("etag", (Object)this.etag).add("friendlyName", (Object)this.friendlyName).add("id", (Object)this.id).add("lastModified", (Object)this.lastModified).add("location", (Object)this.location).add("selfLink", (Object)this.selfLink).add("acl", this.acl).toString();
    }

    public int hashCode() {
        return Objects.hash(this.datasetId);
    }

    public boolean equals(Object obj) {
        return obj instanceof DatasetInfo && Objects.equals(this.toPb(), ((DatasetInfo)obj).toPb());
    }

    Dataset toPb() {
        Dataset datasetPb = new Dataset();
        datasetPb.setDatasetReference(this.datasetId.toPb());
        datasetPb.setCreationTime(this.creationTime);
        datasetPb.setDefaultTableExpirationMs(this.defaultTableLifetime);
        datasetPb.setDescription(this.description);
        datasetPb.setEtag(this.etag);
        datasetPb.setFriendlyName(this.friendlyName);
        datasetPb.setId(this.id);
        datasetPb.setLastModifiedTime(this.lastModified);
        datasetPb.setLocation(this.location);
        datasetPb.setSelfLink(this.selfLink);
        if (this.acl != null) {
            datasetPb.setAccess(Lists.transform(this.acl, (Function)new Function<Acl, Dataset.Access>(){

                public Dataset.Access apply(Acl acl) {
                    return acl.toPb();
                }
            }));
        }
        return datasetPb;
    }

    public static Builder builder(String datasetId) {
        return new Builder().datasetId(DatasetId.of(datasetId));
    }

    public static Builder builder(String projectId, String datasetId) {
        return new Builder().datasetId(DatasetId.of(projectId, datasetId));
    }

    public static Builder builder(DatasetId datasetId) {
        return new Builder().datasetId(datasetId);
    }

    static DatasetInfo fromPb(Dataset datasetPb) {
        Builder builder = DatasetInfo.builder(datasetPb.getDatasetReference().getProjectId(), datasetPb.getDatasetReference().getDatasetId());
        if (datasetPb.getAccess() != null) {
            builder.acl(Lists.transform((List)datasetPb.getAccess(), (Function)new Function<Dataset.Access, Acl>(){

                public Acl apply(Dataset.Access accessPb) {
                    return Acl.fromPb(accessPb);
                }
            }));
        }
        if (datasetPb.getCreationTime() != null) {
            builder.creationTime(datasetPb.getCreationTime());
        }
        if (datasetPb.getDefaultTableExpirationMs() != null) {
            builder.defaultTableLifetime(datasetPb.getDefaultTableExpirationMs());
        }
        if (datasetPb.getDescription() != null) {
            builder.description(datasetPb.getDescription());
        }
        if (datasetPb.getEtag() != null) {
            builder.etag(datasetPb.getEtag());
        }
        if (datasetPb.getFriendlyName() != null) {
            builder.friendlyName(datasetPb.getFriendlyName());
        }
        if (datasetPb.getId() != null) {
            builder.id(datasetPb.getId());
        }
        if (datasetPb.getLastModifiedTime() != null) {
            builder.lastModified(datasetPb.getLastModifiedTime());
        }
        if (datasetPb.getLocation() != null) {
            builder.location(datasetPb.getLocation());
        }
        if (datasetPb.getSelfLink() != null) {
            builder.selfLink(datasetPb.getSelfLink());
        }
        return builder.build();
    }

    public static final class Builder {
        private DatasetId datasetId;
        private List<Acl> acl;
        private Long creationTime;
        private Long defaultTableLifetime;
        private String description;
        private String etag;
        private String friendlyName;
        private String id;
        private Long lastModified;
        private String location;
        private String selfLink;

        private Builder() {
        }

        private Builder(DatasetInfo datasetInfo) {
            this.datasetId = datasetInfo.datasetId;
            this.acl = datasetInfo.acl;
            this.creationTime = datasetInfo.creationTime;
            this.defaultTableLifetime = datasetInfo.defaultTableLifetime;
            this.description = datasetInfo.description;
            this.etag = datasetInfo.etag;
            this.friendlyName = datasetInfo.friendlyName;
            this.id = datasetInfo.id;
            this.lastModified = datasetInfo.lastModified;
            this.location = datasetInfo.location;
            this.selfLink = datasetInfo.selfLink;
        }

        public Builder datasetId(DatasetId datasetId) {
            this.datasetId = (DatasetId)Preconditions.checkNotNull((Object)datasetId);
            return this;
        }

        public Builder acl(List<Acl> acl) {
            this.acl = acl != null ? ImmutableList.copyOf(acl) : null;
            return this;
        }

        Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder defaultTableLifetime(Long defaultTableLifetime) {
            this.defaultTableLifetime = (Long)MoreObjects.firstNonNull((Object)defaultTableLifetime, (Object)Data.nullOf(Long.class));
            return this;
        }

        public Builder description(String description) {
            this.description = (String)MoreObjects.firstNonNull((Object)description, (Object)Data.nullOf(String.class));
            return this;
        }

        Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder friendlyName(String friendlyName) {
            this.friendlyName = (String)MoreObjects.firstNonNull((Object)friendlyName, (Object)Data.nullOf(String.class));
            return this;
        }

        Builder id(String id) {
            this.id = id;
            return this;
        }

        Builder lastModified(Long lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Builder location(String location) {
            this.location = (String)MoreObjects.firstNonNull((Object)location, (Object)Data.nullOf(String.class));
            return this;
        }

        Builder selfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public DatasetInfo build() {
            return new DatasetInfo(this);
        }
    }
}

