/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gcloud.bigquery.CsvOptions;
import com.google.gcloud.bigquery.FormatOptions;
import com.google.gcloud.bigquery.Schema;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ExternalDataConfiguration
implements Serializable {
    static final Function<com.google.api.services.bigquery.model.ExternalDataConfiguration, ExternalDataConfiguration> FROM_PB_FUNCTION = new Function<com.google.api.services.bigquery.model.ExternalDataConfiguration, ExternalDataConfiguration>(){

        public ExternalDataConfiguration apply(com.google.api.services.bigquery.model.ExternalDataConfiguration configurationPb) {
            return ExternalDataConfiguration.fromPb(configurationPb);
        }
    };
    static final Function<ExternalDataConfiguration, com.google.api.services.bigquery.model.ExternalDataConfiguration> TO_PB_FUNCTION = new Function<ExternalDataConfiguration, com.google.api.services.bigquery.model.ExternalDataConfiguration>(){

        public com.google.api.services.bigquery.model.ExternalDataConfiguration apply(ExternalDataConfiguration configuration) {
            return configuration.toPb();
        }
    };
    private static final long serialVersionUID = -8004288831035566549L;
    private final List<String> sourceUris;
    private final Schema schema;
    private final FormatOptions formatOptions;
    private final Integer maxBadRecords;
    private final Boolean ignoreUnknownValues;
    private final String compression;

    ExternalDataConfiguration(Builder builder) {
        this.compression = builder.compression;
        this.ignoreUnknownValues = builder.ignoreUnknownValues;
        this.maxBadRecords = builder.maxBadRecords;
        this.schema = builder.schema;
        this.formatOptions = builder.formatOptions;
        this.sourceUris = builder.sourceUris;
    }

    public String compression() {
        return this.compression;
    }

    public Boolean ignoreUnknownValues() {
        return this.ignoreUnknownValues;
    }

    public Integer maxBadRecords() {
        return this.maxBadRecords;
    }

    public Schema schema() {
        return this.schema;
    }

    public List<String> sourceUris() {
        return this.sourceUris;
    }

    public <F extends FormatOptions> F formatOptions() {
        return (F)this.formatOptions;
    }

    public Builder toBuilder() {
        return new Builder().compression(this.compression).ignoreUnknownValues(this.ignoreUnknownValues).maxBadRecords(this.maxBadRecords).schema(this.schema).formatOptions(this.formatOptions).sourceUris(this.sourceUris);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sourceUris", this.sourceUris).add("formatOptions", (Object)this.formatOptions).add("schema", (Object)this.schema).add("compression", (Object)this.compression).add("ignoreUnknownValues", (Object)this.ignoreUnknownValues).add("maxBadRecords", (Object)this.maxBadRecords).toString();
    }

    public int hashCode() {
        return Objects.hash(this.compression, this.ignoreUnknownValues, this.maxBadRecords, this.schema, this.formatOptions, this.sourceUris);
    }

    public boolean equals(Object obj) {
        return obj instanceof ExternalDataConfiguration && Objects.equals(this.toPb(), ((ExternalDataConfiguration)obj).toPb());
    }

    com.google.api.services.bigquery.model.ExternalDataConfiguration toPb() {
        com.google.api.services.bigquery.model.ExternalDataConfiguration externalConfigurationPb = new com.google.api.services.bigquery.model.ExternalDataConfiguration();
        if (this.compression != null) {
            externalConfigurationPb.setCompression(this.compression);
        }
        if (this.ignoreUnknownValues != null) {
            externalConfigurationPb.setIgnoreUnknownValues(this.ignoreUnknownValues);
        }
        if (this.maxBadRecords != null) {
            externalConfigurationPb.setMaxBadRecords(this.maxBadRecords);
        }
        if (this.schema != null) {
            externalConfigurationPb.setSchema(this.schema.toPb());
        }
        if (this.formatOptions != null) {
            externalConfigurationPb.setSourceFormat(this.formatOptions.type());
        }
        if (this.sourceUris != null) {
            externalConfigurationPb.setSourceUris(this.sourceUris);
        }
        if (this.formatOptions != null && "CSV".equals(this.formatOptions.type())) {
            externalConfigurationPb.setCsvOptions(((CsvOptions)this.formatOptions).toPb());
        }
        return externalConfigurationPb;
    }

    public static Builder builder(List<String> sourceUris, Schema schema, FormatOptions format) {
        return new Builder().sourceUris(sourceUris).schema(schema).formatOptions(format);
    }

    public static Builder builder(String sourceUri, Schema schema, FormatOptions format) {
        return new Builder().sourceUris((List<String>)ImmutableList.of((Object)sourceUri)).schema(schema).formatOptions(format);
    }

    public static ExternalDataConfiguration of(List<String> sourceUris, Schema schema, FormatOptions format) {
        return ExternalDataConfiguration.builder(sourceUris, schema, format).build();
    }

    public static ExternalDataConfiguration of(String sourceUri, Schema schema, FormatOptions format) {
        return ExternalDataConfiguration.builder(sourceUri, schema, format).build();
    }

    static ExternalDataConfiguration fromPb(com.google.api.services.bigquery.model.ExternalDataConfiguration externalDataConfiguration) {
        Builder builder = new Builder();
        if (externalDataConfiguration.getSourceUris() != null) {
            builder.sourceUris(externalDataConfiguration.getSourceUris());
        }
        if (externalDataConfiguration.getSchema() != null) {
            builder.schema(Schema.fromPb(externalDataConfiguration.getSchema()));
        }
        if (externalDataConfiguration.getSourceFormat() != null) {
            builder.formatOptions(FormatOptions.of(externalDataConfiguration.getSourceFormat()));
        }
        if (externalDataConfiguration.getCompression() != null) {
            builder.compression(externalDataConfiguration.getCompression());
        }
        if (externalDataConfiguration.getIgnoreUnknownValues() != null) {
            builder.ignoreUnknownValues(externalDataConfiguration.getIgnoreUnknownValues());
        }
        if (externalDataConfiguration.getCsvOptions() != null) {
            builder.formatOptions(CsvOptions.fromPb(externalDataConfiguration.getCsvOptions()));
        }
        if (externalDataConfiguration.getMaxBadRecords() != null) {
            builder.maxBadRecords(externalDataConfiguration.getMaxBadRecords());
        }
        return builder.build();
    }

    public static final class Builder {
        private List<String> sourceUris;
        private Schema schema;
        private FormatOptions formatOptions;
        private Integer maxBadRecords;
        private Boolean ignoreUnknownValues;
        private String compression;

        private Builder() {
        }

        public Builder sourceUris(List<String> sourceUris) {
            this.sourceUris = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(sourceUris)));
            return this;
        }

        public Builder schema(Schema schema) {
            this.schema = (Schema)Preconditions.checkNotNull((Object)schema);
            return this;
        }

        public Builder formatOptions(FormatOptions formatOptions) {
            this.formatOptions = (FormatOptions)Preconditions.checkNotNull((Object)formatOptions);
            return this;
        }

        public Builder maxBadRecords(Integer maxBadRecords) {
            this.maxBadRecords = maxBadRecords;
            return this;
        }

        public Builder ignoreUnknownValues(Boolean ignoreUnknownValues) {
            this.ignoreUnknownValues = ignoreUnknownValues;
            return this;
        }

        public Builder compression(String compression) {
            this.compression = compression;
            return this;
        }

        public ExternalDataConfiguration build() {
            return new ExternalDataConfiguration(this);
        }
    }
}

