/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.gcloud.bigquery.BaseTableInfo;
import com.google.gcloud.bigquery.ExternalDataConfiguration;
import com.google.gcloud.bigquery.TableId;
import java.util.Objects;

public class ExternalTableInfo
extends BaseTableInfo {
    private static final long serialVersionUID = -5893406738246214865L;
    private final ExternalDataConfiguration configuration;

    private ExternalTableInfo(Builder builder) {
        super(builder);
        this.configuration = builder.configuration;
    }

    public ExternalDataConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("configuration", (Object)this.configuration);
    }

    public boolean equals(Object obj) {
        return obj instanceof ExternalTableInfo && this.baseEquals((ExternalTableInfo)obj);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.configuration);
    }

    @Override
    Table toPb() {
        Table tablePb = super.toPb();
        tablePb.setExternalDataConfiguration(this.configuration.toPb());
        return tablePb;
    }

    public static Builder builder(TableId tableId, ExternalDataConfiguration configuration) {
        return ((Builder)((Builder)new Builder().tableId(tableId)).type(BaseTableInfo.Type.EXTERNAL)).configuration(configuration);
    }

    public static ExternalTableInfo of(TableId table, ExternalDataConfiguration configuration) {
        return ExternalTableInfo.builder(table, configuration).build();
    }

    static ExternalTableInfo fromPb(Table tablePb) {
        return new Builder(tablePb).build();
    }

    public static final class Builder
    extends BaseTableInfo.Builder<ExternalTableInfo, Builder> {
        private ExternalDataConfiguration configuration;

        private Builder() {
        }

        private Builder(ExternalTableInfo tableInfo) {
            super(tableInfo);
            this.configuration = tableInfo.configuration;
        }

        protected Builder(Table tablePb) {
            super(tablePb);
            if (tablePb.getExternalDataConfiguration() != null) {
                this.configuration = ExternalDataConfiguration.fromPb(tablePb.getExternalDataConfiguration());
            }
        }

        public Builder configuration(ExternalDataConfiguration configuration) {
            this.configuration = (ExternalDataConfiguration)Preconditions.checkNotNull((Object)configuration);
            return (Builder)this.self();
        }

        @Override
        public ExternalTableInfo build() {
            return new ExternalTableInfo(this);
        }
    }
}

