/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gcloud.bigquery.JobId;
import com.google.gcloud.bigquery.JobInfo;
import com.google.gcloud.bigquery.JobStatistics;
import com.google.gcloud.bigquery.TableId;
import java.util.List;
import java.util.Objects;

public class ExtractJobInfo
extends JobInfo<JobStatistics.ExtractStatistics> {
    private static final long serialVersionUID = -9126951217071361576L;
    private final TableId sourceTable;
    private final List<String> destinationUris;
    private final Boolean printHeader;
    private final String fieldDelimiter;
    private final String format;
    private final String compression;

    private ExtractJobInfo(Builder builder) {
        super(builder);
        this.sourceTable = (TableId)Preconditions.checkNotNull((Object)builder.sourceTable);
        this.destinationUris = (List)Preconditions.checkNotNull((Object)builder.destinationUris);
        this.printHeader = builder.printHeader;
        this.fieldDelimiter = builder.fieldDelimiter;
        this.format = builder.format;
        this.compression = builder.compression;
    }

    public TableId sourceTable() {
        return this.sourceTable;
    }

    public List<String> destinationUris() {
        return this.destinationUris;
    }

    public Boolean printHeader() {
        return this.printHeader;
    }

    public String fieldDelimiter() {
        return this.fieldDelimiter;
    }

    public String format() {
        return this.format;
    }

    public String compression() {
        return this.compression;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("sourceTable", (Object)this.sourceTable).add("destinationUris", this.destinationUris).add("format", (Object)this.format).add("printHeader", (Object)this.printHeader).add("fieldDelimiter", (Object)this.fieldDelimiter).add("compression", (Object)this.compression);
    }

    public boolean equals(Object obj) {
        return obj instanceof ExtractJobInfo && this.baseEquals((ExtractJobInfo)obj);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.sourceTable, this.destinationUris, this.printHeader, this.fieldDelimiter, this.format, this.compression);
    }

    @Override
    Job toPb() {
        JobConfigurationExtract extractConfigurationPb = new JobConfigurationExtract();
        extractConfigurationPb.setDestinationUris(this.destinationUris);
        extractConfigurationPb.setSourceTable(this.sourceTable.toPb());
        extractConfigurationPb.setPrintHeader(this.printHeader);
        extractConfigurationPb.setFieldDelimiter(this.fieldDelimiter);
        extractConfigurationPb.setDestinationFormat(this.format);
        extractConfigurationPb.setCompression(this.compression);
        return super.toPb().setConfiguration(new JobConfiguration().setExtract(extractConfigurationPb));
    }

    public static Builder builder(TableId sourceTable, String destinationUri) {
        return ExtractJobInfo.builder(sourceTable, (List<String>)ImmutableList.of((Object)Preconditions.checkNotNull((Object)destinationUri)));
    }

    public static Builder builder(TableId sourceTable, List<String> destinationUris) {
        return new Builder().sourceTable(sourceTable).destinationUris(destinationUris);
    }

    public static ExtractJobInfo of(TableId sourceTable, String destinationUri) {
        return ExtractJobInfo.builder(sourceTable, destinationUri).build();
    }

    public static ExtractJobInfo of(TableId sourceTable, List<String> destinationUris) {
        return ExtractJobInfo.builder(sourceTable, destinationUris).build();
    }

    public static ExtractJobInfo of(TableId sourceTable, String format, String destinationUri) {
        return ExtractJobInfo.builder(sourceTable, destinationUri).format(format).build();
    }

    public static ExtractJobInfo of(TableId sourceTable, String format, List<String> destinationUris) {
        return ExtractJobInfo.builder(sourceTable, destinationUris).format(format).build();
    }

    public static ExtractJobInfo of(JobId jobId, TableId sourceTable, String destinationUri) {
        return ((Builder)ExtractJobInfo.builder(sourceTable, destinationUri).jobId(jobId)).build();
    }

    public static ExtractJobInfo of(JobId jobId, TableId sourceTable, List<String> destinationUris) {
        return ((Builder)ExtractJobInfo.builder(sourceTable, destinationUris).jobId(jobId)).build();
    }

    public static ExtractJobInfo of(JobId jobId, TableId sourceTable, String format, String destinationUri) {
        return ((Builder)ExtractJobInfo.builder(sourceTable, destinationUri).format(format).jobId(jobId)).build();
    }

    public static ExtractJobInfo of(JobId jobId, TableId sourceTable, String format, List<String> destinationUris) {
        return ((Builder)ExtractJobInfo.builder(sourceTable, destinationUris).format(format).jobId(jobId)).build();
    }

    static ExtractJobInfo fromPb(Job jobPb) {
        return new Builder(jobPb).build();
    }

    public static final class Builder
    extends JobInfo.Builder<ExtractJobInfo, JobStatistics.ExtractStatistics, Builder> {
        private TableId sourceTable;
        private List<String> destinationUris;
        private Boolean printHeader;
        private String fieldDelimiter;
        private String format;
        private String compression;

        private Builder() {
        }

        private Builder(ExtractJobInfo jobInfo) {
            super(jobInfo);
            this.sourceTable = jobInfo.sourceTable;
            this.destinationUris = jobInfo.destinationUris;
            this.printHeader = jobInfo.printHeader;
            this.fieldDelimiter = jobInfo.fieldDelimiter;
            this.format = jobInfo.format;
            this.compression = jobInfo.compression;
        }

        private Builder(Job jobPb) {
            super(jobPb);
            JobConfigurationExtract extractConfigurationPb = jobPb.getConfiguration().getExtract();
            this.sourceTable = TableId.fromPb(extractConfigurationPb.getSourceTable());
            this.destinationUris = extractConfigurationPb.getDestinationUris();
            this.printHeader = extractConfigurationPb.getPrintHeader();
            this.fieldDelimiter = extractConfigurationPb.getFieldDelimiter();
            this.format = extractConfigurationPb.getDestinationFormat();
            this.compression = extractConfigurationPb.getCompression();
        }

        public Builder sourceTable(TableId sourceTable) {
            this.sourceTable = sourceTable;
            return (Builder)this.self();
        }

        public Builder destinationUris(List<String> destinationUris) {
            this.destinationUris = destinationUris != null ? ImmutableList.copyOf(destinationUris) : null;
            return (Builder)this.self();
        }

        public Builder printHeader(Boolean printHeader) {
            this.printHeader = printHeader;
            return (Builder)this.self();
        }

        public Builder fieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return (Builder)this.self();
        }

        public Builder format(String format) {
            this.format = format;
            return (Builder)this.self();
        }

        public Builder compression(String compression) {
            this.compression = compression;
            return (Builder)this.self();
        }

        @Override
        public ExtractJobInfo build() {
            return new ExtractJobInfo(this);
        }
    }
}

