/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.api.client.util.Data;
import com.google.api.client.util.Lists;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FieldValue
implements Serializable {
    static final Function<Object, FieldValue> FROM_PB_FUNCTION = new Function<Object, FieldValue>(){

        public FieldValue apply(Object pb) {
            return FieldValue.fromPb(pb);
        }
    };
    private static final int MICROSECONDS = 1000000;
    private static final long serialVersionUID = 469098630191710061L;
    private final Attribute attribute;
    private final Object value;

    FieldValue(Attribute attribute, Object value) {
        this.attribute = attribute;
        this.value = value;
    }

    public Attribute attribute() {
        return this.attribute;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public Object value() {
        return this.value;
    }

    public String stringValue() {
        Preconditions.checkNotNull((Object)this.value);
        return (String)this.value;
    }

    public long longValue() {
        return Long.parseLong(this.stringValue());
    }

    public double doubleValue() {
        return Double.parseDouble(this.stringValue());
    }

    public boolean booleanValue() {
        String stringValue = this.stringValue();
        Preconditions.checkState((stringValue.equalsIgnoreCase("true") || stringValue.equalsIgnoreCase("false") ? 1 : 0) != 0, (Object)"Field value is not of boolean type");
        return Boolean.parseBoolean(stringValue);
    }

    public long timestampValue() {
        return new Double(Double.valueOf(this.stringValue()) * 1000000.0).longValue();
    }

    public List<FieldValue> repeatedValue() {
        Preconditions.checkNotNull((Object)this.value);
        return (List)this.value;
    }

    public List<FieldValue> recordValue() {
        Preconditions.checkNotNull((Object)this.value);
        return (List)this.value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attribute", (Object)this.attribute).add("value", this.value).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attribute, this.value});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldValue)) {
            return false;
        }
        FieldValue other = (FieldValue)obj;
        return this.attribute == other.attribute && Objects.equals(this.value, other.value);
    }

    static FieldValue fromPb(Object cellPb) {
        if (Data.isNull((Object)cellPb)) {
            return new FieldValue(Attribute.PRIMITIVE, null);
        }
        if (cellPb instanceof String) {
            return new FieldValue(Attribute.PRIMITIVE, cellPb);
        }
        if (cellPb instanceof List) {
            List cellsListPb = (List)cellPb;
            ArrayList repeatedCells = Lists.newArrayListWithCapacity((int)cellsListPb.size());
            for (Object repeatedCellPb : cellsListPb) {
                repeatedCells.add(FieldValue.fromPb(repeatedCellPb));
            }
            return new FieldValue(Attribute.REPEATED, repeatedCells);
        }
        if (cellPb instanceof Map) {
            Map cellMapPb = (Map)cellPb;
            if (cellMapPb.containsKey("f")) {
                List cellsListPb = (List)cellMapPb.get("f");
                ArrayList recordCells = Lists.newArrayListWithCapacity((int)cellsListPb.size());
                for (Object repeatedCellPb : cellsListPb) {
                    recordCells.add(FieldValue.fromPb(repeatedCellPb));
                }
                return new FieldValue(Attribute.RECORD, recordCells);
            }
            if (cellMapPb.containsKey("v")) {
                return FieldValue.fromPb(cellMapPb.get("v"));
            }
        }
        throw new AssertionError((Object)"Unexpected table cell format");
    }

    public static enum Attribute {
        PRIMITIVE,
        REPEATED,
        RECORD;

    }
}

