/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.common.base.Preconditions;
import com.google.gcloud.bigquery.BigQuery;
import com.google.gcloud.bigquery.JobInfo;
import com.google.gcloud.bigquery.JobStatus;

public final class Job {
    private final BigQuery bigquery;
    private final JobInfo info;

    public Job(BigQuery bigquery, JobInfo info) {
        this.bigquery = (BigQuery)Preconditions.checkNotNull((Object)bigquery);
        this.info = (JobInfo)Preconditions.checkNotNull((Object)info);
    }

    public static Job get(BigQuery bigquery, String job, BigQuery.JobOption ... options) {
        Object info = bigquery.getJob(job, options);
        return info != null ? new Job(bigquery, (JobInfo)info) : null;
    }

    public JobInfo info() {
        return this.info;
    }

    public boolean exists() {
        return this.bigquery.getJob(this.info.jobId(), BigQuery.JobOption.fields(new BigQuery.JobField[0])) != null;
    }

    public boolean isDone() {
        Object job = this.bigquery.getJob(this.info.jobId(), BigQuery.JobOption.fields(BigQuery.JobField.STATUS));
        return job != null && ((JobInfo)job).status().state() == JobStatus.State.DONE;
    }

    public Job reload(BigQuery.JobOption ... options) {
        return Job.get(this.bigquery, this.info.jobId().job(), options);
    }

    public boolean cancel() {
        return this.bigquery.cancel(this.info.jobId());
    }

    public BigQuery bigquery() {
        return this.bigquery;
    }
}

