/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.api.services.bigquery.model.JobReference;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public class JobId
implements Serializable {
    private static final long serialVersionUID = 1225914835379688976L;
    private final String project;
    private final String job;

    public String project() {
        return this.project;
    }

    public String job() {
        return this.job;
    }

    private JobId(String project, String job) {
        this.project = project;
        this.job = job;
    }

    public static JobId of(String project, String job) {
        return new JobId((String)Preconditions.checkNotNull((Object)project), (String)Preconditions.checkNotNull((Object)job));
    }

    public static JobId of(String job) {
        return new JobId(null, (String)Preconditions.checkNotNull((Object)job));
    }

    public boolean equals(Object obj) {
        return obj instanceof JobId && Objects.equals(this.toPb(), ((JobId)obj).toPb());
    }

    public int hashCode() {
        return Objects.hash(this.project, this.job);
    }

    public String toString() {
        return this.toPb().toString();
    }

    JobReference toPb() {
        return new JobReference().setProjectId(this.project).setJobId(this.job);
    }

    static JobId fromPb(JobReference jobRef) {
        return new JobId(jobRef.getProjectId(), jobRef.getJobId());
    }
}

