/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.gcloud.bigquery.CopyJobInfo;
import com.google.gcloud.bigquery.ExtractJobInfo;
import com.google.gcloud.bigquery.JobId;
import com.google.gcloud.bigquery.JobStatistics;
import com.google.gcloud.bigquery.JobStatus;
import com.google.gcloud.bigquery.LoadJobInfo;
import com.google.gcloud.bigquery.QueryJobInfo;
import java.io.Serializable;
import java.util.Objects;

public abstract class JobInfo<S extends JobStatistics>
implements Serializable {
    static final Function<Job, JobInfo> FROM_PB_FUNCTION = new Function<Job, JobInfo>(){

        public JobInfo apply(Job pb) {
            return JobInfo.fromPb(pb);
        }
    };
    private static final long serialVersionUID = -7086529810736715842L;
    private final String etag;
    private final String id;
    private final JobId jobId;
    private final String selfLink;
    private final JobStatus status;
    private final S statistics;
    private final String userEmail;

    protected JobInfo(Builder<? extends JobInfo, ? extends S, ?> builder) {
        this.jobId = ((Builder)builder).jobId;
        this.etag = ((Builder)builder).etag;
        this.id = ((Builder)builder).id;
        this.selfLink = ((Builder)builder).selfLink;
        this.status = ((Builder)builder).status;
        this.statistics = ((Builder)builder).statistics;
        this.userEmail = ((Builder)builder).userEmail;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public JobId jobId() {
        return this.jobId;
    }

    public String selfLink() {
        return this.selfLink;
    }

    public JobStatus status() {
        return this.status;
    }

    public S statistics() {
        return this.statistics;
    }

    public String userEmail() {
        return this.userEmail;
    }

    public abstract Builder toBuilder();

    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("job", (Object)this.jobId).add("status", (Object)this.status).add("statistics", this.statistics).add("userEmail", (Object)this.userEmail).add("etag", (Object)this.etag).add("id", (Object)this.id).add("selfLink", (Object)this.selfLink);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    protected final int baseHashCode() {
        return Objects.hash(this.jobId);
    }

    protected final boolean baseEquals(JobInfo jobInfo) {
        return Objects.equals(this.toPb(), jobInfo.toPb());
    }

    Job toPb() {
        Job jobPb = new Job();
        jobPb.setEtag(this.etag);
        jobPb.setId(this.id);
        jobPb.setSelfLink(this.selfLink);
        jobPb.setUserEmail(this.userEmail);
        if (this.jobId != null) {
            jobPb.setJobReference(this.jobId.toPb());
        }
        if (this.status != null) {
            jobPb.setStatus(this.status.toPb());
        }
        if (this.statistics != null) {
            jobPb.setStatistics(((JobStatistics)this.statistics).toPb());
        }
        return jobPb;
    }

    static <T extends JobInfo> T fromPb(Job jobPb) {
        if (jobPb.getConfiguration().getLoad() != null) {
            return (T)LoadJobInfo.fromPb(jobPb);
        }
        if (jobPb.getConfiguration().getCopy() != null) {
            return (T)CopyJobInfo.fromPb(jobPb);
        }
        if (jobPb.getConfiguration().getExtract() != null) {
            return (T)ExtractJobInfo.fromPb(jobPb);
        }
        if (jobPb.getConfiguration().getQuery() != null) {
            return (T)QueryJobInfo.fromPb(jobPb);
        }
        throw new IllegalArgumentException("Job configuration is not supported");
    }

    public static abstract class Builder<T extends JobInfo, S extends JobStatistics, B extends Builder<T, S, B>> {
        private String etag;
        private String id;
        private JobId jobId;
        private String selfLink;
        private JobStatus status;
        private S statistics;
        private String userEmail;

        protected Builder() {
        }

        protected Builder(JobInfo<S> jobInfo) {
            this.etag = ((JobInfo)jobInfo).etag;
            this.id = ((JobInfo)jobInfo).id;
            this.jobId = ((JobInfo)jobInfo).jobId;
            this.selfLink = ((JobInfo)jobInfo).selfLink;
            this.status = ((JobInfo)jobInfo).status;
            this.statistics = ((JobInfo)jobInfo).statistics;
            this.userEmail = ((JobInfo)jobInfo).userEmail;
        }

        protected Builder(Job jobPb) {
            this.etag = jobPb.getEtag();
            this.id = jobPb.getId();
            if (jobPb.getJobReference() != null) {
                this.jobId = JobId.fromPb(jobPb.getJobReference());
            }
            this.selfLink = jobPb.getSelfLink();
            if (jobPb.getStatus() != null) {
                this.status = JobStatus.fromPb(jobPb.getStatus());
            }
            if (jobPb.getStatistics() != null) {
                this.statistics = JobStatistics.fromPb(jobPb.getStatistics());
            }
            this.userEmail = jobPb.getUserEmail();
        }

        protected B self() {
            return (B)this;
        }

        B etag(String etag) {
            this.etag = etag;
            return this.self();
        }

        B id(String id) {
            this.id = id;
            return this.self();
        }

        public B jobId(JobId jobId) {
            this.jobId = jobId;
            return this.self();
        }

        B selfLink(String selfLink) {
            this.selfLink = selfLink;
            return this.self();
        }

        B status(JobStatus status) {
            this.status = status;
            return this.self();
        }

        B statistics(S statistics) {
            this.statistics = statistics;
            return this.self();
        }

        B userEmail(String userEmail) {
            this.userEmail = userEmail;
            return this.self();
        }

        public abstract T build();
    }

    public static enum WriteDisposition {
        WRITE_TRUNCATE,
        WRITE_APPEND,
        WRITE_EMPTY;

    }

    public static enum CreateDisposition {
        CREATE_IF_NEEDED,
        CREATE_NEVER;

    }
}

