/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gcloud.bigquery.CsvOptions;
import com.google.gcloud.bigquery.FormatOptions;
import com.google.gcloud.bigquery.JobInfo;
import com.google.gcloud.bigquery.Schema;
import com.google.gcloud.bigquery.TableId;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class LoadConfiguration
implements Serializable {
    private static final long serialVersionUID = 470267591917413578L;
    private final TableId destinationTable;
    private final JobInfo.CreateDisposition createDisposition;
    private final JobInfo.WriteDisposition writeDisposition;
    private final FormatOptions formatOptions;
    private final Integer maxBadRecords;
    private final Schema schema;
    private final Boolean ignoreUnknownValues;
    private final List<String> projectionFields;

    private LoadConfiguration(Builder builder) {
        this.destinationTable = (TableId)Preconditions.checkNotNull((Object)builder.destinationTable);
        this.createDisposition = builder.createDisposition;
        this.writeDisposition = builder.writeDisposition;
        this.formatOptions = builder.formatOptions;
        this.maxBadRecords = builder.maxBadRecords;
        this.schema = builder.schema;
        this.ignoreUnknownValues = builder.ignoreUnknownValues;
        this.projectionFields = builder.projectionFields;
    }

    public TableId destinationTable() {
        return this.destinationTable;
    }

    public JobInfo.CreateDisposition createDisposition() {
        return this.createDisposition;
    }

    public JobInfo.WriteDisposition writeDisposition() {
        return this.writeDisposition;
    }

    public CsvOptions csvOptions() {
        return this.formatOptions instanceof CsvOptions ? (CsvOptions)this.formatOptions : null;
    }

    public Integer maxBadRecords() {
        return this.maxBadRecords;
    }

    public Schema schema() {
        return this.schema;
    }

    public String format() {
        return this.formatOptions != null ? this.formatOptions.type() : null;
    }

    public Boolean ignoreUnknownValues() {
        return this.ignoreUnknownValues;
    }

    public List<String> projectionFields() {
        return this.projectionFields;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("destinationTable", (Object)this.destinationTable).add("createDisposition", (Object)this.createDisposition).add("writeDisposition", (Object)this.writeDisposition).add("formatOptions", (Object)this.formatOptions).add("maxBadRecords", (Object)this.maxBadRecords).add("schema", (Object)this.schema).add("ignoreUnknownValue", (Object)this.ignoreUnknownValues).add("projectionFields", this.projectionFields).toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof LoadConfiguration && Objects.equals(this.toPb(), ((LoadConfiguration)obj).toPb());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.destinationTable, this.createDisposition, this.writeDisposition, this.formatOptions, this.maxBadRecords, this.schema, this.ignoreUnknownValues, this.projectionFields});
    }

    JobConfigurationLoad toPb() {
        JobConfigurationLoad loadConfigurationPb = new JobConfigurationLoad();
        loadConfigurationPb.setDestinationTable(this.destinationTable.toPb());
        if (this.createDisposition != null) {
            loadConfigurationPb.setCreateDisposition(this.createDisposition.toString());
        }
        if (this.writeDisposition != null) {
            loadConfigurationPb.setWriteDisposition(this.writeDisposition.toString());
        }
        if (this.csvOptions() != null) {
            CsvOptions csvOptions = this.csvOptions();
            loadConfigurationPb.setFieldDelimiter(csvOptions.fieldDelimiter()).setAllowJaggedRows(csvOptions.allowJaggedRows()).setAllowQuotedNewlines(csvOptions.allowQuotedNewLines()).setEncoding(csvOptions.encoding()).setQuote(csvOptions.quote()).setSkipLeadingRows(csvOptions.skipLeadingRows());
        }
        if (this.schema != null) {
            loadConfigurationPb.setSchema(this.schema.toPb());
        }
        if (this.formatOptions != null) {
            loadConfigurationPb.setSourceFormat(this.formatOptions.type());
        }
        loadConfigurationPb.setMaxBadRecords(this.maxBadRecords);
        loadConfigurationPb.setIgnoreUnknownValues(this.ignoreUnknownValues);
        loadConfigurationPb.setProjectionFields(this.projectionFields);
        return loadConfigurationPb;
    }

    static LoadConfiguration fromPb(JobConfigurationLoad configurationPb) {
        return new Builder(configurationPb).build();
    }

    public static Builder builder(TableId destinationTable) {
        return new Builder().destinationTable(destinationTable);
    }

    public static Builder builder(TableId destinationTable, FormatOptions format) {
        return new Builder().destinationTable(destinationTable).formatOptions(format);
    }

    public static LoadConfiguration of(TableId destinationTable) {
        return LoadConfiguration.builder(destinationTable).build();
    }

    public static LoadConfiguration of(TableId destinationTable, FormatOptions format) {
        return LoadConfiguration.builder(destinationTable).formatOptions(format).build();
    }

    public static final class Builder {
        private TableId destinationTable;
        private JobInfo.CreateDisposition createDisposition;
        private JobInfo.WriteDisposition writeDisposition;
        private FormatOptions formatOptions;
        private Integer maxBadRecords;
        private Schema schema;
        private Boolean ignoreUnknownValues;
        private List<String> projectionFields;

        private Builder() {
        }

        private Builder(LoadConfiguration loadConfiguration) {
            this.destinationTable = loadConfiguration.destinationTable;
            this.createDisposition = loadConfiguration.createDisposition;
            this.writeDisposition = loadConfiguration.writeDisposition;
            this.formatOptions = loadConfiguration.formatOptions;
            this.maxBadRecords = loadConfiguration.maxBadRecords;
            this.schema = loadConfiguration.schema;
            this.ignoreUnknownValues = loadConfiguration.ignoreUnknownValues;
            this.projectionFields = loadConfiguration.projectionFields;
        }

        private Builder(JobConfigurationLoad loadConfigurationPb) {
            this.destinationTable = TableId.fromPb(loadConfigurationPb.getDestinationTable());
            if (loadConfigurationPb.getCreateDisposition() != null) {
                this.createDisposition = JobInfo.CreateDisposition.valueOf(loadConfigurationPb.getCreateDisposition());
            }
            if (loadConfigurationPb.getWriteDisposition() != null) {
                this.writeDisposition = JobInfo.WriteDisposition.valueOf(loadConfigurationPb.getWriteDisposition());
            }
            if (loadConfigurationPb.getSourceFormat() != null) {
                this.formatOptions = FormatOptions.of(loadConfigurationPb.getSourceFormat());
            }
            if (loadConfigurationPb.getAllowJaggedRows() != null || loadConfigurationPb.getAllowQuotedNewlines() != null || loadConfigurationPb.getEncoding() != null || loadConfigurationPb.getFieldDelimiter() != null || loadConfigurationPb.getQuote() != null || loadConfigurationPb.getSkipLeadingRows() != null) {
                CsvOptions.Builder builder = CsvOptions.builder().allowJaggedRows(loadConfigurationPb.getAllowJaggedRows()).allowQuotedNewLines(loadConfigurationPb.getAllowQuotedNewlines()).encoding(loadConfigurationPb.getEncoding()).fieldDelimiter(loadConfigurationPb.getFieldDelimiter()).quote(loadConfigurationPb.getQuote()).skipLeadingRows(loadConfigurationPb.getSkipLeadingRows());
                this.formatOptions = builder.build();
            }
            this.maxBadRecords = loadConfigurationPb.getMaxBadRecords();
            if (loadConfigurationPb.getSchema() != null) {
                this.schema = Schema.fromPb(loadConfigurationPb.getSchema());
            }
            this.ignoreUnknownValues = loadConfigurationPb.getIgnoreUnknownValues();
            this.projectionFields = loadConfigurationPb.getProjectionFields();
        }

        public Builder destinationTable(TableId destinationTable) {
            this.destinationTable = destinationTable;
            return this;
        }

        public Builder createDisposition(JobInfo.CreateDisposition createDisposition) {
            this.createDisposition = createDisposition;
            return this;
        }

        public Builder writeDisposition(JobInfo.WriteDisposition writeDisposition) {
            this.writeDisposition = writeDisposition;
            return this;
        }

        public Builder formatOptions(FormatOptions formatOptions) {
            this.formatOptions = formatOptions;
            return this;
        }

        public Builder maxBadRecords(Integer maxBadRecords) {
            this.maxBadRecords = maxBadRecords;
            return this;
        }

        public Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public Builder ignoreUnknownValues(Boolean ignoreUnknownValues) {
            this.ignoreUnknownValues = ignoreUnknownValues;
            return this;
        }

        public Builder projectionFields(List<String> projectionFields) {
            this.projectionFields = projectionFields != null ? ImmutableList.copyOf(projectionFields) : null;
            return this;
        }

        public LoadConfiguration build() {
            return new LoadConfiguration(this);
        }
    }
}

