/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gcloud.bigquery.JobId;
import com.google.gcloud.bigquery.JobInfo;
import com.google.gcloud.bigquery.JobStatistics;
import com.google.gcloud.bigquery.LoadConfiguration;
import java.util.List;
import java.util.Objects;

public class LoadJobInfo
extends JobInfo<JobStatistics.LoadStatistics> {
    private static final long serialVersionUID = 6349304826867750535L;
    private final List<String> sourceUris;
    private final LoadConfiguration configuration;

    private LoadJobInfo(Builder builder) {
        super(builder);
        this.sourceUris = builder.sourceUris;
        this.configuration = builder.configuration;
    }

    public List<String> sourceUris() {
        return this.sourceUris;
    }

    public LoadConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("sourceUris", this.sourceUris).add("configuration", (Object)this.configuration);
    }

    public boolean equals(Object obj) {
        return obj instanceof LoadJobInfo && this.baseEquals((LoadJobInfo)obj);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.sourceUris, this.configuration);
    }

    @Override
    Job toPb() {
        JobConfigurationLoad loadConfigurationPb = this.configuration.toPb();
        loadConfigurationPb.setSourceUris(this.sourceUris);
        return super.toPb().setConfiguration(new JobConfiguration().setLoad(loadConfigurationPb));
    }

    public static Builder builder(LoadConfiguration configuration, String sourceUri) {
        return LoadJobInfo.builder(configuration, (List<String>)ImmutableList.of((Object)Preconditions.checkNotNull((Object)sourceUri)));
    }

    public static Builder builder(LoadConfiguration configuration, List<String> sourceUris) {
        return new Builder().configuration(configuration).sourceUris(sourceUris);
    }

    public static LoadJobInfo of(LoadConfiguration configuration, String sourceUri) {
        return LoadJobInfo.builder(configuration, sourceUri).build();
    }

    public static LoadJobInfo of(LoadConfiguration configuration, List<String> sourceUris) {
        return LoadJobInfo.builder(configuration, sourceUris).build();
    }

    public static LoadJobInfo of(JobId jobId, LoadConfiguration configuration, String sourceUri) {
        return ((Builder)LoadJobInfo.builder(configuration, sourceUri).jobId(jobId)).build();
    }

    public static LoadJobInfo of(JobId jobId, LoadConfiguration configuration, List<String> sourceUris) {
        return ((Builder)LoadJobInfo.builder(configuration, sourceUris).jobId(jobId)).build();
    }

    static LoadJobInfo fromPb(Job jobPb) {
        return new Builder(jobPb).build();
    }

    public static final class Builder
    extends JobInfo.Builder<LoadJobInfo, JobStatistics.LoadStatistics, Builder> {
        private List<String> sourceUris;
        private LoadConfiguration configuration;

        private Builder() {
        }

        private Builder(LoadJobInfo jobInfo) {
            super(jobInfo);
            this.sourceUris = jobInfo.sourceUris;
            this.configuration = jobInfo.configuration;
        }

        private Builder(Job jobPb) {
            super(jobPb);
            JobConfigurationLoad loadConfigurationPb = jobPb.getConfiguration().getLoad();
            this.configuration = LoadConfiguration.fromPb(loadConfigurationPb);
            this.sourceUris = loadConfigurationPb.getSourceUris();
        }

        public Builder sourceUris(List<String> sourceUris) {
            this.sourceUris = sourceUris != null ? ImmutableList.copyOf(sourceUris) : null;
            return this;
        }

        public Builder configuration(LoadConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public LoadJobInfo build() {
            return new LoadJobInfo(this);
        }
    }
}

