/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gcloud.bigquery.DatasetId;
import com.google.gcloud.bigquery.ExternalDataConfiguration;
import com.google.gcloud.bigquery.JobId;
import com.google.gcloud.bigquery.JobInfo;
import com.google.gcloud.bigquery.JobStatistics;
import com.google.gcloud.bigquery.TableId;
import com.google.gcloud.bigquery.UserDefinedFunction;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QueryJobInfo
extends JobInfo<JobStatistics.QueryStatistics> {
    private static final long serialVersionUID = -8708709356039780158L;
    private final String query;
    private final TableId destinationTable;
    private final Map<String, ExternalDataConfiguration> tableDefinitions;
    private final List<UserDefinedFunction> userDefinedFunctions;
    private final JobInfo.CreateDisposition createDisposition;
    private final JobInfo.WriteDisposition writeDisposition;
    private final DatasetId defaultDataset;
    private final Priority priority;
    private final Boolean allowLargeResults;
    private final Boolean useQueryCache;
    private final Boolean flattenResults;
    private final Boolean dryRun;

    private QueryJobInfo(Builder builder) {
        super(builder);
        this.query = (String)Preconditions.checkNotNull((Object)builder.query);
        this.allowLargeResults = builder.allowLargeResults;
        this.createDisposition = builder.createDisposition;
        this.defaultDataset = builder.defaultDataset;
        this.destinationTable = builder.destinationTable;
        this.flattenResults = builder.flattenResults;
        this.priority = builder.priority;
        this.useQueryCache = builder.useQueryCache;
        this.userDefinedFunctions = builder.userDefinedFunctions;
        this.writeDisposition = builder.writeDisposition;
        this.tableDefinitions = builder.tableDefinitions != null ? ImmutableMap.copyOf((Map)builder.tableDefinitions) : null;
        this.dryRun = builder.dryRun;
    }

    public Boolean allowLargeResults() {
        return this.allowLargeResults;
    }

    public JobInfo.CreateDisposition createDisposition() {
        return this.createDisposition;
    }

    public DatasetId defaultDataset() {
        return this.defaultDataset;
    }

    public TableId destinationTable() {
        return this.destinationTable;
    }

    public Boolean flattenResults() {
        return this.flattenResults;
    }

    public Priority priority() {
        return this.priority;
    }

    public String query() {
        return this.query;
    }

    public Map<String, ExternalDataConfiguration> tableDefinitions() {
        return this.tableDefinitions;
    }

    public Boolean useQueryCache() {
        return this.useQueryCache;
    }

    public List<UserDefinedFunction> userDefinedFunctions() {
        return this.userDefinedFunctions;
    }

    public JobInfo.WriteDisposition writeDisposition() {
        return this.writeDisposition;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("query", (Object)this.query).add("destinationTable", (Object)this.destinationTable).add("defaultDataset", (Object)this.defaultDataset).add("allowLargeResults", (Object)this.allowLargeResults).add("flattenResults", (Object)this.flattenResults).add("priority", (Object)this.priority).add("tableDefinitions", this.tableDefinitions).add("userQueryCache", (Object)this.useQueryCache).add("userDefinedFunctions", this.userDefinedFunctions).add("createDisposition", (Object)this.createDisposition).add("writeDisposition", (Object)this.writeDisposition).add("dryRun", (Object)this.dryRun);
    }

    public boolean equals(Object obj) {
        return obj instanceof QueryJobInfo && this.baseEquals((QueryJobInfo)obj);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseHashCode(), this.allowLargeResults, this.createDisposition, this.destinationTable, this.defaultDataset, this.flattenResults, this.priority, this.query, this.tableDefinitions, this.useQueryCache, this.userDefinedFunctions, this.writeDisposition, this.dryRun});
    }

    @Override
    Job toPb() {
        JobConfiguration configurationPb = new JobConfiguration();
        JobConfigurationQuery queryConfigurationPb = new JobConfigurationQuery();
        queryConfigurationPb.setQuery(this.query);
        configurationPb.setDryRun(this.dryRun());
        if (this.allowLargeResults != null) {
            queryConfigurationPb.setAllowLargeResults(this.allowLargeResults);
        }
        if (this.createDisposition != null) {
            queryConfigurationPb.setCreateDisposition(this.createDisposition.toString());
        }
        if (this.destinationTable != null) {
            queryConfigurationPb.setDestinationTable(this.destinationTable.toPb());
        }
        if (this.defaultDataset != null) {
            queryConfigurationPb.setDefaultDataset(this.defaultDataset.toPb());
        }
        if (this.flattenResults != null) {
            queryConfigurationPb.setFlattenResults(this.flattenResults);
        }
        if (this.priority != null) {
            queryConfigurationPb.setPriority(this.priority.toString());
        }
        if (this.tableDefinitions != null) {
            queryConfigurationPb.setTableDefinitions(Maps.transformValues(this.tableDefinitions, ExternalDataConfiguration.TO_PB_FUNCTION));
        }
        if (this.useQueryCache != null) {
            queryConfigurationPb.setUseQueryCache(this.useQueryCache);
        }
        if (this.userDefinedFunctions != null) {
            queryConfigurationPb.setUserDefinedFunctionResources(Lists.transform(this.userDefinedFunctions, UserDefinedFunction.TO_PB_FUNCTION));
        }
        if (this.writeDisposition != null) {
            queryConfigurationPb.setWriteDisposition(this.writeDisposition.toString());
        }
        return super.toPb().setConfiguration(configurationPb.setQuery(queryConfigurationPb));
    }

    public static Builder builder(String query) {
        return new Builder().query(query);
    }

    public static QueryJobInfo of(String query) {
        return QueryJobInfo.builder(query).build();
    }

    public static QueryJobInfo of(JobId jobId, String query) {
        return ((Builder)QueryJobInfo.builder(query).jobId(jobId)).build();
    }

    static QueryJobInfo fromPb(Job jobPb) {
        return new Builder(jobPb).build();
    }

    public static final class Builder
    extends JobInfo.Builder<QueryJobInfo, JobStatistics.QueryStatistics, Builder> {
        private String query;
        private TableId destinationTable;
        private Map<String, ExternalDataConfiguration> tableDefinitions;
        private List<UserDefinedFunction> userDefinedFunctions;
        private JobInfo.CreateDisposition createDisposition;
        private JobInfo.WriteDisposition writeDisposition;
        private DatasetId defaultDataset;
        private Priority priority;
        private Boolean allowLargeResults;
        private Boolean useQueryCache;
        private Boolean flattenResults;
        private Boolean dryRun;

        private Builder() {
        }

        private Builder(QueryJobInfo jobInfo) {
            super(jobInfo);
            this.query = jobInfo.query;
            this.destinationTable = jobInfo.destinationTable;
            this.tableDefinitions = jobInfo.tableDefinitions;
            this.userDefinedFunctions = jobInfo.userDefinedFunctions;
            this.createDisposition = jobInfo.createDisposition;
            this.writeDisposition = jobInfo.writeDisposition;
            this.defaultDataset = jobInfo.defaultDataset;
            this.priority = jobInfo.priority;
            this.allowLargeResults = jobInfo.allowLargeResults;
            this.useQueryCache = jobInfo.useQueryCache;
            this.flattenResults = jobInfo.flattenResults;
            this.dryRun = jobInfo.dryRun;
        }

        private Builder(Job jobPb) {
            super(jobPb);
            JobConfigurationQuery queryConfigurationPb = jobPb.getConfiguration().getQuery();
            this.query = queryConfigurationPb.getQuery();
            this.allowLargeResults = queryConfigurationPb.getAllowLargeResults();
            this.useQueryCache = queryConfigurationPb.getUseQueryCache();
            this.flattenResults = queryConfigurationPb.getFlattenResults();
            this.dryRun = jobPb.getConfiguration().getDryRun();
            if (queryConfigurationPb.getDestinationTable() != null) {
                this.destinationTable = TableId.fromPb(queryConfigurationPb.getDestinationTable());
            }
            if (queryConfigurationPb.getDefaultDataset() != null) {
                this.defaultDataset = DatasetId.fromPb(queryConfigurationPb.getDefaultDataset());
            }
            if (queryConfigurationPb.getPriority() != null) {
                this.priority = Priority.valueOf(queryConfigurationPb.getPriority());
            }
            if (queryConfigurationPb.getTableDefinitions() != null) {
                this.tableDefinitions = Maps.transformValues((Map)queryConfigurationPb.getTableDefinitions(), ExternalDataConfiguration.FROM_PB_FUNCTION);
            }
            if (queryConfigurationPb.getUserDefinedFunctionResources() != null) {
                this.userDefinedFunctions = Lists.transform((List)queryConfigurationPb.getUserDefinedFunctionResources(), UserDefinedFunction.FROM_PB_FUNCTION);
            }
            if (queryConfigurationPb.getCreateDisposition() != null) {
                this.createDisposition = JobInfo.CreateDisposition.valueOf(queryConfigurationPb.getCreateDisposition());
            }
            if (queryConfigurationPb.getWriteDisposition() != null) {
                this.writeDisposition = JobInfo.WriteDisposition.valueOf(queryConfigurationPb.getWriteDisposition());
            }
        }

        public Builder query(String query) {
            this.query = query;
            return (Builder)this.self();
        }

        public Builder destinationTable(TableId destinationTable) {
            this.destinationTable = destinationTable;
            return (Builder)this.self();
        }

        public Builder tableDefinitions(Map<String, ExternalDataConfiguration> tableDefinitions) {
            this.tableDefinitions = tableDefinitions != null ? Maps.newHashMap(tableDefinitions) : null;
            return (Builder)this.self();
        }

        public Builder addTableDefinition(String tableName, ExternalDataConfiguration tableDefinition) {
            if (this.tableDefinitions == null) {
                this.tableDefinitions = Maps.newHashMap();
            }
            this.tableDefinitions.put((String)Preconditions.checkNotNull((Object)tableName), (ExternalDataConfiguration)Preconditions.checkNotNull((Object)tableDefinition));
            return (Builder)this.self();
        }

        public Builder userDefinedFunctions(List<UserDefinedFunction> userDefinedFunctions) {
            this.userDefinedFunctions = userDefinedFunctions != null ? ImmutableList.copyOf(userDefinedFunctions) : null;
            return (Builder)this.self();
        }

        public Builder createDisposition(JobInfo.CreateDisposition createDisposition) {
            this.createDisposition = createDisposition;
            return (Builder)this.self();
        }

        public Builder writeDisposition(JobInfo.WriteDisposition writeDisposition) {
            this.writeDisposition = writeDisposition;
            return (Builder)this.self();
        }

        public Builder defaultDataset(DatasetId defaultDataset) {
            this.defaultDataset = defaultDataset;
            return (Builder)this.self();
        }

        public Builder defaultDataset(String defaultDataset) {
            return this.defaultDataset(DatasetId.of(defaultDataset));
        }

        public Builder priority(Priority priority) {
            this.priority = priority;
            return (Builder)this.self();
        }

        public Builder allowLargeResults(Boolean allowLargeResults) {
            this.allowLargeResults = allowLargeResults;
            return (Builder)this.self();
        }

        public Builder useQueryCache(Boolean useQueryCache) {
            this.useQueryCache = useQueryCache;
            return (Builder)this.self();
        }

        public Builder flattenResults(Boolean flattenResults) {
            this.flattenResults = flattenResults;
            return (Builder)this.self();
        }

        public Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return (Builder)this.self();
        }

        @Override
        public QueryJobInfo build() {
            return new QueryJobInfo(this);
        }
    }

    public static enum Priority {
        INTERACTIVE,
        BATCH;

    }
}

