/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.gcloud.bigquery.DatasetId;
import java.io.Serializable;
import java.util.Objects;

public class QueryRequest
implements Serializable {
    private static final long serialVersionUID = -8727328332415880852L;
    private final String query;
    private final Long maxResults;
    private final DatasetId defaultDataset;
    private final Long maxWaitTime;
    private final Boolean dryRun;
    private final Boolean useQueryCache;

    private QueryRequest(Builder builder) {
        this.query = builder.query;
        this.maxResults = builder.maxResults;
        this.defaultDataset = builder.defaultDataset;
        this.maxWaitTime = builder.maxWaitTime;
        this.dryRun = builder.dryRun;
        this.useQueryCache = builder.useQueryCache;
    }

    public String query() {
        return this.query;
    }

    public Long maxResults() {
        return this.maxResults;
    }

    public DatasetId defaultDataset() {
        return this.defaultDataset;
    }

    public Long maxWaitTime() {
        return this.maxWaitTime;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    public Boolean useQueryCache() {
        return this.useQueryCache;
    }

    public Builder toBuilder() {
        return new Builder().query(this.query).maxResults(this.maxResults).defaultDataset(this.defaultDataset).maxWaitTime(this.maxWaitTime).dryRun(this.dryRun).useQueryCache(this.useQueryCache);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("query", (Object)this.query).add("maxResults", (Object)this.maxResults).add("defaultDataset", (Object)this.defaultDataset).add("maxWaitTime", (Object)this.maxWaitTime).add("dryRun", (Object)this.dryRun).add("useQueryCache", (Object)this.useQueryCache).toString();
    }

    public int hashCode() {
        return Objects.hash(this.query, this.maxResults, this.defaultDataset, this.maxWaitTime, this.dryRun, this.useQueryCache);
    }

    public boolean equals(Object obj) {
        return obj instanceof QueryRequest && Objects.equals(this.toPb(), ((QueryRequest)obj).toPb());
    }

    com.google.api.services.bigquery.model.QueryRequest toPb() {
        com.google.api.services.bigquery.model.QueryRequest queryRequestPb = new com.google.api.services.bigquery.model.QueryRequest().setQuery(this.query);
        if (this.maxResults != null) {
            queryRequestPb.setMaxResults(this.maxResults);
        }
        if (this.defaultDataset != null) {
            queryRequestPb.setDefaultDataset(this.defaultDataset.toPb());
        }
        if (this.maxWaitTime != null) {
            queryRequestPb.setTimeoutMs(this.maxWaitTime);
        }
        if (this.dryRun != null) {
            queryRequestPb.setDryRun(this.dryRun);
        }
        if (this.useQueryCache != null) {
            queryRequestPb.setUseQueryCache(this.useQueryCache);
        }
        return queryRequestPb;
    }

    public static Builder builder(String query) {
        return new Builder().query(query);
    }

    public static QueryRequest of(String query) {
        return new Builder().query(query).build();
    }

    static QueryRequest fromPb(com.google.api.services.bigquery.model.QueryRequest queryRequestPb) {
        Builder builder = QueryRequest.builder(queryRequestPb.getQuery());
        if (queryRequestPb.getMaxResults() != null) {
            builder.maxResults(queryRequestPb.getMaxResults());
        }
        if (queryRequestPb.getDefaultDataset() != null) {
            builder.defaultDataset(DatasetId.fromPb(queryRequestPb.getDefaultDataset()));
        }
        if (queryRequestPb.getTimeoutMs() != null) {
            builder.maxWaitTime(queryRequestPb.getTimeoutMs());
        }
        if (queryRequestPb.getDryRun() != null) {
            builder.dryRun(queryRequestPb.getDryRun());
        }
        if (queryRequestPb.getUseQueryCache() != null) {
            builder.useQueryCache(queryRequestPb.getUseQueryCache());
        }
        return builder.build();
    }

    public static final class Builder {
        private String query;
        private Long maxResults;
        private DatasetId defaultDataset;
        private Long maxWaitTime;
        private Boolean dryRun;
        private Boolean useQueryCache;

        private Builder() {
        }

        public Builder query(String query) {
            this.query = (String)Preconditions.checkNotNull((Object)query);
            return this;
        }

        public Builder maxResults(Long maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public Builder defaultDataset(DatasetId defaultDataset) {
            this.defaultDataset = defaultDataset;
            return this;
        }

        public Builder defaultDataset(String defaultDataset) {
            return this.defaultDataset(DatasetId.of(defaultDataset));
        }

        public Builder maxWaitTime(Long maxWaitTime) {
            this.maxWaitTime = maxWaitTime;
            return this;
        }

        public Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public Builder useQueryCache(Boolean useQueryCache) {
            this.useQueryCache = useQueryCache;
            return this;
        }

        public QueryRequest build() {
            return new QueryRequest(this);
        }
    }
}

