/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.api.services.bigquery.model.ExplainQueryStage;
import com.google.api.services.bigquery.model.ExplainQueryStep;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class QueryStage
implements Serializable {
    static final Function<ExplainQueryStage, QueryStage> FROM_PB_FUNCTION = new Function<ExplainQueryStage, QueryStage>(){

        public QueryStage apply(ExplainQueryStage pb) {
            return QueryStage.fromPb(pb);
        }
    };
    static final Function<QueryStage, ExplainQueryStage> TO_PB_FUNCTION = new Function<QueryStage, ExplainQueryStage>(){

        public ExplainQueryStage apply(QueryStage stage) {
            return stage.toPb();
        }
    };
    private static final long serialVersionUID = -472281297327952320L;
    private final double computeRatioAvg;
    private final double computeRatioMax;
    private final long id;
    private final String name;
    private final double readRatioAvg;
    private final double readRatioMax;
    private final long recordsRead;
    private final long recordsWritten;
    private final List<QueryStep> steps;
    private final double waitRatioAvg;
    private final double waitRatioMax;
    private final double writeRatioAvg;
    private final double writeRatioMax;

    QueryStage(Builder builder) {
        this.computeRatioAvg = builder.computeRatioAvg;
        this.computeRatioMax = builder.computeRatioMax;
        this.id = builder.id;
        this.name = builder.name;
        this.readRatioAvg = builder.readRatioAvg;
        this.readRatioMax = builder.readRatioMax;
        this.recordsRead = builder.recordsRead;
        this.recordsWritten = builder.recordsWritten;
        this.steps = builder.steps;
        this.waitRatioAvg = builder.waitRatioAvg;
        this.waitRatioMax = builder.waitRatioMax;
        this.writeRatioAvg = builder.writeRatioAvg;
        this.writeRatioMax = builder.writeRatioMax;
    }

    public double computeRatioAvg() {
        return this.computeRatioAvg;
    }

    public double computeRatioMax() {
        return this.computeRatioMax;
    }

    public long id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public double readRatioAvg() {
        return this.readRatioAvg;
    }

    public double readRatioMax() {
        return this.readRatioMax;
    }

    public long recordsRead() {
        return this.recordsRead;
    }

    public long recordsWritten() {
        return this.recordsWritten;
    }

    public List<QueryStep> steps() {
        return this.steps;
    }

    public double waitRatioAvg() {
        return this.waitRatioAvg;
    }

    public double waitRatioMax() {
        return this.waitRatioMax;
    }

    public double writeRatioAvg() {
        return this.writeRatioAvg;
    }

    public double writeRatioMax() {
        return this.writeRatioMax;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("computeRatioAvg", this.computeRatioAvg).add("computeRatioMax", this.computeRatioMax).add("id", this.id).add("name", (Object)this.name).add("readRatioAvg", this.readRatioAvg).add("readRatioMax", this.readRatioMax).add("recordsRead", this.recordsRead).add("recordsWritten", this.recordsWritten).add("steps", this.steps).add("waitRatioAvg", this.waitRatioAvg).add("waitRatioMax", this.waitRatioMax).add("writeRatioAvg", this.writeRatioAvg).add("writeRatioMax", this.writeRatioMax).toString();
    }

    public int hashCode() {
        return Objects.hash(this.computeRatioAvg, this.computeRatioMax, this.id, this.name, this.readRatioAvg, this.readRatioMax, this.recordsRead, this.recordsWritten, this.steps, this.waitRatioAvg, this.waitRatioMax, this.writeRatioAvg);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QueryStage)) {
            return false;
        }
        QueryStage other = (QueryStage)obj;
        return this.id == other.id && this.computeRatioAvg == other.computeRatioAvg && this.computeRatioMax == other.computeRatioMax && this.readRatioAvg == other.readRatioAvg && this.readRatioMax == other.readRatioMax && this.recordsRead == other.recordsRead && this.recordsWritten == other.recordsWritten && this.waitRatioAvg == other.waitRatioAvg && this.waitRatioMax == other.waitRatioMax && this.writeRatioAvg == other.writeRatioAvg && this.writeRatioMax == other.writeRatioMax && Objects.equals(this.steps, other.steps) && Objects.equals(this.name, other.name);
    }

    static Builder builder() {
        return new Builder();
    }

    ExplainQueryStage toPb() {
        ExplainQueryStage stagePb = new ExplainQueryStage().setComputeRatioAvg(Double.valueOf(this.computeRatioAvg)).setComputeRatioMax(Double.valueOf(this.computeRatioMax)).setId(Long.valueOf(this.id)).setName(this.name).setReadRatioAvg(Double.valueOf(this.readRatioAvg)).setReadRatioMax(Double.valueOf(this.readRatioMax)).setRecordsRead(Long.valueOf(this.recordsRead)).setRecordsWritten(Long.valueOf(this.recordsWritten)).setWaitRatioAvg(Double.valueOf(this.waitRatioAvg)).setWaitRatioMax(Double.valueOf(this.waitRatioMax)).setWriteRatioAvg(Double.valueOf(this.writeRatioAvg)).setWriteRatioMax(Double.valueOf(this.writeRatioMax));
        if (this.steps != null) {
            stagePb.setSteps(Lists.transform(this.steps, QueryStep.TO_PB_FUNCTION));
        }
        return stagePb;
    }

    static QueryStage fromPb(ExplainQueryStage stagePb) {
        Builder builder = new Builder();
        builder.computeRatioAvg(stagePb.getComputeRatioAvg());
        builder.computeRatioMax(stagePb.getComputeRatioMax());
        builder.id(stagePb.getId());
        builder.name(stagePb.getName());
        builder.readRatioAvg(stagePb.getReadRatioAvg());
        builder.readRatioMax(stagePb.getReadRatioMax());
        builder.recordsRead(stagePb.getRecordsRead());
        builder.recordsWritten(stagePb.getRecordsWritten());
        if (stagePb.getSteps() != null) {
            builder.steps(Lists.transform((List)stagePb.getSteps(), QueryStep.FROM_PB_FUNCTION));
        }
        builder.waitRatioAvg(stagePb.getWaitRatioAvg());
        builder.waitRatioMax(stagePb.getWaitRatioMax());
        builder.writeRatioAvg(stagePb.getWriteRatioAvg());
        builder.writeRatioMax(stagePb.getWriteRatioMax());
        return builder.build();
    }

    static final class Builder {
        private double computeRatioAvg;
        private double computeRatioMax;
        private long id;
        private String name;
        private double readRatioAvg;
        private double readRatioMax;
        private long recordsRead;
        private long recordsWritten;
        private List<QueryStep> steps;
        private double waitRatioAvg;
        private double waitRatioMax;
        private double writeRatioAvg;
        private double writeRatioMax;

        private Builder() {
        }

        Builder computeRatioAvg(double computeRatioAvg) {
            this.computeRatioAvg = computeRatioAvg;
            return this;
        }

        Builder computeRatioMax(double computeRatioMax) {
            this.computeRatioMax = computeRatioMax;
            return this;
        }

        Builder id(long id) {
            this.id = id;
            return this;
        }

        Builder name(String name) {
            this.name = name;
            return this;
        }

        Builder readRatioAvg(double readRatioAvg) {
            this.readRatioAvg = readRatioAvg;
            return this;
        }

        Builder readRatioMax(double readRatioMax) {
            this.readRatioMax = readRatioMax;
            return this;
        }

        Builder recordsRead(long recordsRead) {
            this.recordsRead = recordsRead;
            return this;
        }

        Builder recordsWritten(long recordsWritten) {
            this.recordsWritten = recordsWritten;
            return this;
        }

        Builder steps(List<QueryStep> steps) {
            this.steps = steps;
            return this;
        }

        Builder waitRatioAvg(double waitRatioAvg) {
            this.waitRatioAvg = waitRatioAvg;
            return this;
        }

        Builder waitRatioMax(double waitRatioMax) {
            this.waitRatioMax = waitRatioMax;
            return this;
        }

        Builder writeRatioAvg(double writeRatioAvg) {
            this.writeRatioAvg = writeRatioAvg;
            return this;
        }

        Builder writeRatioMax(double writeRatioMax) {
            this.writeRatioMax = writeRatioMax;
            return this;
        }

        QueryStage build() {
            return new QueryStage(this);
        }
    }

    public static class QueryStep
    implements Serializable {
        static final Function<ExplainQueryStep, QueryStep> FROM_PB_FUNCTION = new Function<ExplainQueryStep, QueryStep>(){

            public QueryStep apply(ExplainQueryStep pb) {
                return QueryStep.fromPb(pb);
            }
        };
        static final Function<QueryStep, ExplainQueryStep> TO_PB_FUNCTION = new Function<QueryStep, ExplainQueryStep>(){

            public ExplainQueryStep apply(QueryStep stage) {
                return stage.toPb();
            }
        };
        private static final long serialVersionUID = 8663444604771794411L;
        private final String name;
        private final List<String> substeps;

        QueryStep(String name, List<String> substeps) {
            this.name = name;
            this.substeps = substeps;
        }

        public String name() {
            return this.name;
        }

        public List<String> substeps() {
            return this.substeps;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("substeps", this.substeps).toString();
        }

        public int hashCode() {
            return Objects.hash(this.name, this.substeps);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof QueryStep)) {
                return false;
            }
            QueryStep other = (QueryStep)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.substeps, other.substeps);
        }

        ExplainQueryStep toPb() {
            return new ExplainQueryStep().setKind(this.name).setSubsteps(this.substeps);
        }

        static QueryStep fromPb(ExplainQueryStep stepPb) {
            return new QueryStep(stepPb.getKind(), (List<String>)ImmutableList.copyOf((Collection)(stepPb.getSubsteps() != null ? stepPb.getSubsteps() : ImmutableList.of())));
        }
    }
}

