/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gcloud.Page;
import com.google.gcloud.bigquery.BaseTableInfo;
import com.google.gcloud.bigquery.BigQuery;
import com.google.gcloud.bigquery.BigQueryException;
import com.google.gcloud.bigquery.CopyJobInfo;
import com.google.gcloud.bigquery.ExtractJobInfo;
import com.google.gcloud.bigquery.FieldValue;
import com.google.gcloud.bigquery.FormatOptions;
import com.google.gcloud.bigquery.InsertAllRequest;
import com.google.gcloud.bigquery.InsertAllResponse;
import com.google.gcloud.bigquery.Job;
import com.google.gcloud.bigquery.LoadConfiguration;
import com.google.gcloud.bigquery.LoadJobInfo;
import com.google.gcloud.bigquery.TableId;
import java.util.List;
import java.util.Objects;

public final class Table {
    private final BigQuery bigquery;
    private final BaseTableInfo info;

    public Table(BigQuery bigquery, BaseTableInfo info) {
        this.bigquery = (BigQuery)Preconditions.checkNotNull((Object)bigquery);
        this.info = (BaseTableInfo)Preconditions.checkNotNull((Object)info);
    }

    public static Table get(BigQuery bigquery, String dataset, String table, BigQuery.TableOption ... options) {
        return Table.get(bigquery, TableId.of(dataset, table), options);
    }

    public static Table get(BigQuery bigquery, TableId table, BigQuery.TableOption ... options) {
        Object info = bigquery.getTable(table, options);
        return info != null ? new Table(bigquery, (BaseTableInfo)info) : null;
    }

    public BaseTableInfo info() {
        return this.info;
    }

    public boolean exists() {
        return this.bigquery.getTable(this.info.tableId(), BigQuery.TableOption.fields(new BigQuery.TableField[0])) != null;
    }

    public Table reload(BigQuery.TableOption ... options) {
        return Table.get(this.bigquery, this.info.tableId(), options);
    }

    public Table update(BaseTableInfo tableInfo, BigQuery.TableOption ... options) {
        Preconditions.checkArgument((boolean)Objects.equals(tableInfo.tableId().dataset(), this.info.tableId().dataset()), (Object)"Dataset's user-defined ids must match");
        Preconditions.checkArgument((boolean)Objects.equals(tableInfo.tableId().table(), this.info.tableId().table()), (Object)"Table's user-defined ids must match");
        return new Table(this.bigquery, this.bigquery.update(tableInfo, options));
    }

    public boolean delete() {
        return this.bigquery.delete(this.info.tableId());
    }

    InsertAllResponse insert(Iterable<InsertAllRequest.RowToInsert> rows) throws BigQueryException {
        return this.bigquery.insertAll(InsertAllRequest.of(this.info.tableId(), rows));
    }

    InsertAllResponse insert(Iterable<InsertAllRequest.RowToInsert> rows, boolean skipInvalidRows, boolean ignoreUnknownValues) throws BigQueryException {
        InsertAllRequest request = InsertAllRequest.builder(this.info.tableId(), rows).skipInvalidRows(skipInvalidRows).ignoreUnknownValues(ignoreUnknownValues).build();
        return this.bigquery.insertAll(request);
    }

    Page<List<FieldValue>> list(BigQuery.TableDataListOption ... options) throws BigQueryException {
        return this.bigquery.listTableData(this.info.tableId(), options);
    }

    Job copy(String destinationDataset, String destinationTable, BigQuery.JobOption ... options) throws BigQueryException {
        return this.copy(TableId.of(destinationDataset, destinationTable), options);
    }

    Job copy(TableId destinationTable, BigQuery.JobOption ... options) throws BigQueryException {
        CopyJobInfo job = this.bigquery.create(CopyJobInfo.of(destinationTable, this.info.tableId()), options);
        return new Job(this.bigquery, job);
    }

    Job extract(String format, String destinationUri, BigQuery.JobOption ... options) throws BigQueryException {
        return this.extract(format, (List<String>)ImmutableList.of((Object)destinationUri), options);
    }

    Job extract(String format, List<String> destinationUris, BigQuery.JobOption ... options) throws BigQueryException {
        return new Job(this.bigquery, this.bigquery.create(ExtractJobInfo.of(this.info.tableId(), format, destinationUris), options));
    }

    Job load(FormatOptions format, String sourceUri, BigQuery.JobOption ... options) throws BigQueryException {
        return this.load(format, (List<String>)ImmutableList.of((Object)sourceUri), options);
    }

    Job load(FormatOptions format, List<String> sourceUris, BigQuery.JobOption ... options) throws BigQueryException {
        LoadConfiguration configuration = LoadConfiguration.of(this.info.tableId(), format);
        return new Job(this.bigquery, this.bigquery.create(LoadJobInfo.of(configuration, sourceUris), options));
    }

    public BigQuery bigquery() {
        return this.bigquery;
    }
}

