/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.gcloud.BaseWriteChannel;
import com.google.gcloud.ExceptionHandler;
import com.google.gcloud.RestorableState;
import com.google.gcloud.RetryHelper;
import com.google.gcloud.RetryParams;
import com.google.gcloud.ServiceOptions;
import com.google.gcloud.WriteChannel;
import com.google.gcloud.bigquery.BigQueryException;
import com.google.gcloud.bigquery.BigQueryImpl;
import com.google.gcloud.bigquery.BigQueryOptions;
import com.google.gcloud.bigquery.LoadConfiguration;
import com.google.gcloud.spi.BigQueryRpc;
import java.io.Serializable;
import java.util.concurrent.Executors;

class TableDataWriteChannel
extends BaseWriteChannel<BigQueryOptions, LoadConfiguration> {
    TableDataWriteChannel(BigQueryOptions options, LoadConfiguration loadConfiguration) {
        this(options, loadConfiguration, ((BigQueryRpc)options.rpc()).open(loadConfiguration.toPb()));
    }

    TableDataWriteChannel(BigQueryOptions options, LoadConfiguration config, String uploadId) {
        super((ServiceOptions)options, (Serializable)config, uploadId);
    }

    protected void flushBuffer(final int length, final boolean last) {
        try {
            RetryHelper.runWithRetries(Executors.callable(new Runnable(){

                @Override
                public void run() {
                    ((BigQueryRpc)((BigQueryOptions)TableDataWriteChannel.this.options()).rpc()).write(TableDataWriteChannel.this.uploadId(), TableDataWriteChannel.this.buffer(), 0, TableDataWriteChannel.this.position(), length, last);
                }
            }), (RetryParams)((BigQueryOptions)this.options()).retryParams(), (ExceptionHandler)BigQueryImpl.EXCEPTION_HANDLER);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    protected StateImpl.Builder stateBuilder() {
        return StateImpl.builder((BigQueryOptions)this.options(), (LoadConfiguration)this.entity(), this.uploadId());
    }

    static class StateImpl
    extends BaseWriteChannel.BaseState<BigQueryOptions, LoadConfiguration> {
        private static final long serialVersionUID = -787362105981823738L;

        StateImpl(Builder builder) {
            super((BaseWriteChannel.BaseState.Builder)builder);
        }

        static Builder builder(BigQueryOptions options, LoadConfiguration config, String uploadId) {
            return new Builder(options, config, uploadId);
        }

        public WriteChannel restore() {
            TableDataWriteChannel channel = new TableDataWriteChannel((BigQueryOptions)this.serviceOptions, (LoadConfiguration)this.entity, this.uploadId);
            channel.restore(this);
            return channel;
        }

        static class Builder
        extends BaseWriteChannel.BaseState.Builder<BigQueryOptions, LoadConfiguration> {
            private Builder(BigQueryOptions options, LoadConfiguration configuration, String uploadId) {
                super((ServiceOptions)options, (Serializable)configuration, uploadId);
            }

            public RestorableState<WriteChannel> build() {
                return new StateImpl(this);
            }
        }
    }
}

