/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public class TableId
implements Serializable {
    static final Function<TableReference, TableId> FROM_PB_FUNCTION = new Function<TableReference, TableId>(){

        public TableId apply(TableReference pb) {
            return TableId.fromPb(pb);
        }
    };
    static final Function<TableId, TableReference> TO_PB_FUNCTION = new Function<TableId, TableReference>(){

        public TableReference apply(TableId tableId) {
            return tableId.toPb();
        }
    };
    private static final long serialVersionUID = -6186254820908152300L;
    private final String project;
    private final String dataset;
    private final String table;

    public String project() {
        return this.project;
    }

    public String dataset() {
        return this.dataset;
    }

    public String table() {
        return this.table;
    }

    private TableId(String project, String dataset, String table) {
        this.project = project;
        this.dataset = dataset;
        this.table = table;
    }

    public static TableId of(String project, String dataset, String table) {
        return new TableId((String)Preconditions.checkNotNull((Object)project), (String)Preconditions.checkNotNull((Object)dataset), (String)Preconditions.checkNotNull((Object)table));
    }

    public static TableId of(String dataset, String table) {
        return new TableId(null, (String)Preconditions.checkNotNull((Object)dataset), (String)Preconditions.checkNotNull((Object)table));
    }

    public boolean equals(Object obj) {
        return obj instanceof TableId && Objects.equals(this.toPb(), ((TableId)obj).toPb());
    }

    public int hashCode() {
        return Objects.hash(this.project, this.dataset, this.table);
    }

    public String toString() {
        return this.toPb().toString();
    }

    TableReference toPb() {
        return new TableReference().setProjectId(this.project).setDatasetId(this.dataset).setTableId(this.table);
    }

    static TableId fromPb(TableReference tableRef) {
        return new TableId(tableRef.getProjectId(), tableRef.getDatasetId(), tableRef.getTableId());
    }
}

