/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.api.services.bigquery.model.Streamingbuffer;
import com.google.api.services.bigquery.model.Table;
import com.google.common.base.MoreObjects;
import com.google.gcloud.bigquery.BaseTableInfo;
import com.google.gcloud.bigquery.Schema;
import com.google.gcloud.bigquery.TableId;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;

public class TableInfo
extends BaseTableInfo {
    private static final long serialVersionUID = -5910575573063546949L;
    private final String location;
    private final StreamingBuffer streamingBuffer;

    private TableInfo(Builder builder) {
        super(builder);
        this.location = builder.location;
        this.streamingBuffer = builder.streamingBuffer;
    }

    public String location() {
        return this.location;
    }

    public StreamingBuffer streamingBuffer() {
        return this.streamingBuffer;
    }

    public static Builder builder(TableId tableId, Schema schema) {
        return (Builder)((Builder)((Builder)new Builder().tableId(tableId)).type(BaseTableInfo.Type.TABLE)).schema(schema);
    }

    public static TableInfo of(TableId tableId, Schema schema) {
        return TableInfo.builder(tableId, schema).build();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("location", (Object)this.location).add("streamingBuffer", (Object)this.streamingBuffer);
    }

    public boolean equals(Object obj) {
        return obj instanceof TableInfo && this.baseEquals((TableInfo)obj);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.location, this.streamingBuffer);
    }

    @Override
    Table toPb() {
        Table tablePb = super.toPb();
        tablePb.setLocation(this.location);
        if (this.streamingBuffer != null) {
            tablePb.setStreamingBuffer(this.streamingBuffer.toPb());
        }
        return tablePb;
    }

    static TableInfo fromPb(Table tablePb) {
        return new Builder(tablePb).build();
    }

    public static final class Builder
    extends BaseTableInfo.Builder<TableInfo, Builder> {
        private String location;
        private StreamingBuffer streamingBuffer;

        private Builder() {
        }

        private Builder(TableInfo tableInfo) {
            super(tableInfo);
            this.location = tableInfo.location;
            this.streamingBuffer = tableInfo.streamingBuffer;
        }

        protected Builder(Table tablePb) {
            super(tablePb);
            this.location = tablePb.getLocation();
            if (tablePb.getStreamingBuffer() != null) {
                this.streamingBuffer = StreamingBuffer.fromPb(tablePb.getStreamingBuffer());
            }
        }

        Builder location(String location) {
            this.location = location;
            return (Builder)this.self();
        }

        Builder streamingBuffer(StreamingBuffer streamingBuffer) {
            this.streamingBuffer = streamingBuffer;
            return (Builder)this.self();
        }

        @Override
        public TableInfo build() {
            return new TableInfo(this);
        }
    }

    public static class StreamingBuffer
    implements Serializable {
        private static final long serialVersionUID = -6713971364725267597L;
        private final long estimatedRows;
        private final long estimatedBytes;
        private final long oldestEntryTime;

        StreamingBuffer(long estimatedRows, long estimatedBytes, long oldestEntryTime) {
            this.estimatedRows = estimatedRows;
            this.estimatedBytes = estimatedBytes;
            this.oldestEntryTime = oldestEntryTime;
        }

        public long estimatedRows() {
            return this.estimatedRows;
        }

        public long estimatedBytes() {
            return this.estimatedBytes;
        }

        public long oldestEntryTime() {
            return this.oldestEntryTime;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("estimatedRows", this.estimatedRows).add("estimatedBytes", this.estimatedBytes).add("oldestEntryTime", this.oldestEntryTime).toString();
        }

        public int hashCode() {
            return Objects.hash(this.estimatedRows, this.estimatedBytes, this.oldestEntryTime);
        }

        public boolean equals(Object obj) {
            return obj instanceof StreamingBuffer && Objects.equals(this.toPb(), ((StreamingBuffer)obj).toPb());
        }

        Streamingbuffer toPb() {
            return new Streamingbuffer().setEstimatedBytes(BigInteger.valueOf(this.estimatedBytes)).setEstimatedRows(BigInteger.valueOf(this.estimatedRows)).setOldestEntryTime(BigInteger.valueOf(this.oldestEntryTime));
        }

        static StreamingBuffer fromPb(Streamingbuffer streamingBufferPb) {
            return new StreamingBuffer(streamingBufferPb.getEstimatedRows().longValue(), streamingBufferPb.getEstimatedBytes().longValue(), streamingBufferPb.getOldestEntryTime().longValue());
        }
    }
}

