/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.ViewDefinition;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gcloud.bigquery.BaseTableInfo;
import com.google.gcloud.bigquery.TableId;
import com.google.gcloud.bigquery.UserDefinedFunction;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ViewInfo
extends BaseTableInfo {
    private static final long serialVersionUID = 7567772157817454901L;
    private final String query;
    private final List<UserDefinedFunction> userDefinedFunctions;

    private ViewInfo(Builder builder) {
        super(builder);
        this.query = builder.query;
        this.userDefinedFunctions = builder.userDefinedFunctions;
    }

    public String query() {
        return this.query;
    }

    public List<UserDefinedFunction> userDefinedFunctions() {
        return this.userDefinedFunctions;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("query", (Object)this.query).add("userDefinedFunctions", this.userDefinedFunctions);
    }

    public boolean equals(Object obj) {
        return obj instanceof ViewInfo && this.baseEquals((ViewInfo)obj);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.query, this.userDefinedFunctions);
    }

    @Override
    Table toPb() {
        Table tablePb = super.toPb();
        ViewDefinition viewDefinition = new ViewDefinition().setQuery(this.query);
        if (this.userDefinedFunctions != null) {
            viewDefinition.setUserDefinedFunctionResources(Lists.transform(this.userDefinedFunctions, UserDefinedFunction.TO_PB_FUNCTION));
        }
        tablePb.setView(viewDefinition);
        return tablePb;
    }

    public static Builder builder(TableId tableId, String query) {
        return ((Builder)((Builder)new Builder().tableId(tableId)).type(BaseTableInfo.Type.VIEW)).query(query);
    }

    public static Builder builder(TableId table, String query, List<UserDefinedFunction> functions) {
        return ((Builder)((Builder)new Builder().tableId(table)).type(BaseTableInfo.Type.VIEW)).userDefinedFunctions(functions).query(query);
    }

    public static Builder builder(TableId table, String query, UserDefinedFunction ... functions) {
        return ((Builder)((Builder)new Builder().tableId(table)).type(BaseTableInfo.Type.VIEW)).userDefinedFunctions(functions).query(query);
    }

    public static ViewInfo of(TableId tableId, String query) {
        return ViewInfo.builder(tableId, query).build();
    }

    public static ViewInfo of(TableId table, String query, List<UserDefinedFunction> functions) {
        return ViewInfo.builder(table, query, functions).build();
    }

    public static ViewInfo of(TableId table, String query, UserDefinedFunction ... functions) {
        return ViewInfo.builder(table, query, functions).build();
    }

    static ViewInfo fromPb(Table tablePb) {
        return new Builder(tablePb).build();
    }

    public static final class Builder
    extends BaseTableInfo.Builder<ViewInfo, Builder> {
        private String query;
        private List<UserDefinedFunction> userDefinedFunctions;

        private Builder() {
        }

        private Builder(ViewInfo viewInfo) {
            super(viewInfo);
            this.query = viewInfo.query;
            this.userDefinedFunctions = viewInfo.userDefinedFunctions;
        }

        protected Builder(Table tablePb) {
            super(tablePb);
            ViewDefinition viewPb = tablePb.getView();
            if (viewPb != null) {
                this.query = viewPb.getQuery();
                if (viewPb.getUserDefinedFunctionResources() != null) {
                    this.userDefinedFunctions = Lists.transform((List)viewPb.getUserDefinedFunctionResources(), UserDefinedFunction.FROM_PB_FUNCTION);
                }
            }
        }

        public Builder query(String query) {
            this.query = (String)Preconditions.checkNotNull((Object)query);
            return (Builder)this.self();
        }

        public Builder userDefinedFunctions(List<UserDefinedFunction> userDefinedFunctions) {
            this.userDefinedFunctions = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(userDefinedFunctions)));
            return (Builder)this.self();
        }

        public Builder userDefinedFunctions(UserDefinedFunction ... userDefinedFunctions) {
            this.userDefinedFunctions = ImmutableList.copyOf((Object[])userDefinedFunctions);
            return (Builder)this.self();
        }

        @Override
        public ViewInfo build() {
            return new ViewInfo(this);
        }
    }
}

