/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.bigquery.testing;

import com.google.gcloud.AuthCredentials;
import com.google.gcloud.RetryParams;
import com.google.gcloud.bigquery.BigQuery;
import com.google.gcloud.bigquery.BigQueryOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteBigQueryHelper {
    private static final Logger log = Logger.getLogger(RemoteBigQueryHelper.class.getName());
    private static final String DATASET_NAME_PREFIX = "gcloud_test_dataset_temp_";
    private final BigQueryOptions options;

    private RemoteBigQueryHelper(BigQueryOptions options) {
        this.options = options;
    }

    public BigQueryOptions options() {
        return this.options;
    }

    public static boolean forceDelete(BigQuery bigquery, String dataset) {
        return bigquery.delete(dataset, BigQuery.DatasetDeleteOption.deleteContents());
    }

    public static String generateDatasetName() {
        return DATASET_NAME_PREFIX + UUID.randomUUID().toString().replace('-', '_');
    }

    public static RemoteBigQueryHelper create(String projectId, InputStream keyStream) throws BigQueryHelperException {
        try {
            BigQueryOptions bigqueryOptions = ((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.builder().authCredentials((AuthCredentials)AuthCredentials.createForJson((InputStream)keyStream))).projectId(projectId)).retryParams(RemoteBigQueryHelper.retryParams())).connectTimeout(60000)).readTimeout(60000)).build();
            return new RemoteBigQueryHelper(bigqueryOptions);
        }
        catch (IOException ex) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, ex.getMessage());
            }
            throw BigQueryHelperException.translate(ex);
        }
    }

    public static RemoteBigQueryHelper create() {
        BigQueryOptions bigqueryOptions = ((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.builder().retryParams(RemoteBigQueryHelper.retryParams())).connectTimeout(60000)).readTimeout(60000)).build();
        return new RemoteBigQueryHelper(bigqueryOptions);
    }

    private static RetryParams retryParams() {
        return RetryParams.builder().retryMaxAttempts(10).retryMinAttempts(6).maxRetryDelayMillis(30000L).totalRetryPeriodMillis(120000L).initialRetryDelayMillis(250L).build();
    }

    public static class BigQueryHelperException
    extends RuntimeException {
        private static final long serialVersionUID = 3984993496060055562L;

        public BigQueryHelperException(String message, Throwable cause) {
            super(message, cause);
        }

        public static BigQueryHelperException translate(Exception ex) {
            return new BigQueryHelperException(ex.getMessage(), ex);
        }
    }
}

