/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.spi;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetList;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobList;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableList;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.gcloud.bigquery.BigQueryException;
import com.google.gcloud.bigquery.BigQueryOptions;
import com.google.gcloud.spi.BigQueryRpc;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public class DefaultBigQueryRpc
implements BigQueryRpc {
    public static final String DEFAULT_PROJECTION = "full";
    private static final String BASE_RESUMABLE_URI = "https://www.googleapis.com/upload/bigquery/v2/projects/";
    private static final int HTTP_RESUME_INCOMPLETE = 308;
    private final BigQueryOptions options;
    private final Bigquery bigquery;

    public DefaultBigQueryRpc(BigQueryOptions options) {
        HttpTransport transport = options.httpTransportFactory().create();
        HttpRequestInitializer initializer = options.httpRequestInitializer();
        this.options = options;
        this.bigquery = new Bigquery.Builder(transport, (JsonFactory)new JacksonFactory(), initializer).setRootUrl(options.host()).setApplicationName(options.applicationName()).build();
    }

    private static BigQueryException translate(IOException exception) {
        return new BigQueryException(exception);
    }

    @Override
    public Dataset getDataset(String datasetId, Map<BigQueryRpc.Option, ?> options) throws BigQueryException {
        try {
            return (Dataset)this.bigquery.datasets().get(this.options.projectId(), datasetId).setFields(BigQueryRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            BigQueryException serviceException = DefaultBigQueryRpc.translate(ex);
            if (serviceException.code() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    @Override
    public BigQueryRpc.Tuple<String, Iterable<Dataset>> listDatasets(Map<BigQueryRpc.Option, ?> options) throws BigQueryException {
        try {
            DatasetList datasetsList = (DatasetList)this.bigquery.datasets().list(this.options.projectId()).setAll(BigQueryRpc.Option.ALL_DATASETS.getBoolean(options)).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options)).execute();
            List datasets = datasetsList.getDatasets();
            return BigQueryRpc.Tuple.of(datasetsList.getNextPageToken(), Iterables.transform((Iterable)(datasets != null ? datasets : ImmutableList.of()), (Function)new Function<DatasetList.Datasets, Dataset>(){

                public Dataset apply(DatasetList.Datasets datasetPb) {
                    return new Dataset().setDatasetReference(datasetPb.getDatasetReference()).setFriendlyName(datasetPb.getFriendlyName()).setId(datasetPb.getId()).setKind(datasetPb.getKind());
                }
            }));
        }
        catch (IOException ex) {
            throw DefaultBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Dataset create(Dataset dataset, Map<BigQueryRpc.Option, ?> options) throws BigQueryException {
        try {
            return (Dataset)this.bigquery.datasets().insert(this.options.projectId(), dataset).setFields(BigQueryRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw DefaultBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Table create(Table table, Map<BigQueryRpc.Option, ?> options) throws BigQueryException {
        try {
            table.setType(null);
            return (Table)this.bigquery.tables().insert(this.options.projectId(), table.getTableReference().getDatasetId(), table).setFields(BigQueryRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw DefaultBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Job create(Job job, Map<BigQueryRpc.Option, ?> options) throws BigQueryException {
        try {
            return (Job)this.bigquery.jobs().insert(this.options.projectId(), job).setFields(BigQueryRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw DefaultBigQueryRpc.translate(ex);
        }
    }

    @Override
    public boolean deleteDataset(String datasetId, Map<BigQueryRpc.Option, ?> options) throws BigQueryException {
        try {
            this.bigquery.datasets().delete(this.options.projectId(), datasetId).setDeleteContents(BigQueryRpc.Option.DELETE_CONTENTS.getBoolean(options)).execute();
            return true;
        }
        catch (IOException ex) {
            BigQueryException serviceException = DefaultBigQueryRpc.translate(ex);
            if (serviceException.code() == 404) {
                return false;
            }
            throw serviceException;
        }
    }

    @Override
    public Dataset patch(Dataset dataset, Map<BigQueryRpc.Option, ?> options) throws BigQueryException {
        try {
            DatasetReference reference = dataset.getDatasetReference();
            return (Dataset)this.bigquery.datasets().patch(this.options.projectId(), reference.getDatasetId(), dataset).setFields(BigQueryRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw DefaultBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Table patch(Table table, Map<BigQueryRpc.Option, ?> options) throws BigQueryException {
        try {
            table.setType(null);
            TableReference reference = table.getTableReference();
            return (Table)this.bigquery.tables().patch(this.options.projectId(), reference.getDatasetId(), reference.getTableId(), table).setFields(BigQueryRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw DefaultBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Table getTable(String datasetId, String tableId, Map<BigQueryRpc.Option, ?> options) throws BigQueryException {
        try {
            return (Table)this.bigquery.tables().get(this.options.projectId(), datasetId, tableId).setFields(BigQueryRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            BigQueryException serviceException = DefaultBigQueryRpc.translate(ex);
            if (serviceException.code() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    @Override
    public BigQueryRpc.Tuple<String, Iterable<Table>> listTables(String datasetId, Map<BigQueryRpc.Option, ?> options) throws BigQueryException {
        try {
            TableList tableList = (TableList)this.bigquery.tables().list(this.options.projectId(), datasetId).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options)).execute();
            List tables = tableList.getTables();
            return BigQueryRpc.Tuple.of(tableList.getNextPageToken(), Iterables.transform((Iterable)(tables != null ? tables : ImmutableList.of()), (Function)new Function<TableList.Tables, Table>(){

                public Table apply(TableList.Tables tablePb) {
                    return new Table().setFriendlyName(tablePb.getFriendlyName()).setId(tablePb.getId()).setKind(tablePb.getKind()).setTableReference(tablePb.getTableReference()).setType(tablePb.getType());
                }
            }));
        }
        catch (IOException ex) {
            throw DefaultBigQueryRpc.translate(ex);
        }
    }

    @Override
    public boolean deleteTable(String datasetId, String tableId) throws BigQueryException {
        try {
            this.bigquery.tables().delete(this.options.projectId(), datasetId, tableId).execute();
            return true;
        }
        catch (IOException ex) {
            BigQueryException serviceException = DefaultBigQueryRpc.translate(ex);
            if (serviceException.code() == 404) {
                return false;
            }
            throw serviceException;
        }
    }

    @Override
    public TableDataInsertAllResponse insertAll(String datasetId, String tableId, TableDataInsertAllRequest request) throws BigQueryException {
        try {
            return (TableDataInsertAllResponse)this.bigquery.tabledata().insertAll(this.options.projectId(), datasetId, tableId, request).execute();
        }
        catch (IOException ex) {
            throw DefaultBigQueryRpc.translate(ex);
        }
    }

    @Override
    public BigQueryRpc.Tuple<String, Iterable<TableRow>> listTableData(String datasetId, String tableId, Map<BigQueryRpc.Option, ?> options) throws BigQueryException {
        try {
            TableDataList tableDataList = (TableDataList)this.bigquery.tabledata().list(this.options.projectId(), datasetId, tableId).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options)).setStartIndex(BigQueryRpc.Option.START_INDEX.getLong(options) != null ? BigInteger.valueOf(BigQueryRpc.Option.START_INDEX.getLong(options)) : null).execute();
            return BigQueryRpc.Tuple.of(tableDataList.getPageToken(), tableDataList.getRows());
        }
        catch (IOException ex) {
            throw DefaultBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Job getJob(String jobId, Map<BigQueryRpc.Option, ?> options) throws BigQueryException {
        try {
            return (Job)this.bigquery.jobs().get(this.options.projectId(), jobId).setFields(BigQueryRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            BigQueryException serviceException = DefaultBigQueryRpc.translate(ex);
            if (serviceException.code() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    @Override
    public BigQueryRpc.Tuple<String, Iterable<Job>> listJobs(Map<BigQueryRpc.Option, ?> options) throws BigQueryException {
        try {
            JobList jobsList = (JobList)this.bigquery.jobs().list(this.options.projectId()).setAllUsers(BigQueryRpc.Option.ALL_USERS.getBoolean(options)).setFields(BigQueryRpc.Option.FIELDS.getString(options)).setStateFilter((List)BigQueryRpc.Option.STATE_FILTER.get(options)).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options)).setProjection(DEFAULT_PROJECTION).execute();
            List jobs = jobsList.getJobs();
            return BigQueryRpc.Tuple.of(jobsList.getNextPageToken(), Iterables.transform((Iterable)(jobs != null ? jobs : ImmutableList.of()), (Function)new Function<JobList.Jobs, Job>(){

                public Job apply(JobList.Jobs jobPb) {
                    JobStatus statusPb;
                    JobStatus jobStatus = statusPb = jobPb.getStatus() != null ? jobPb.getStatus() : new JobStatus();
                    if (statusPb.getState() == null) {
                        statusPb.setState(jobPb.getState());
                    }
                    if (statusPb.getErrorResult() == null) {
                        statusPb.setErrorResult(jobPb.getErrorResult());
                    }
                    return new Job().setConfiguration(jobPb.getConfiguration()).setId(jobPb.getId()).setJobReference(jobPb.getJobReference()).setKind(jobPb.getKind()).setStatistics(jobPb.getStatistics()).setStatus(statusPb).setUserEmail(jobPb.getUserEmail());
                }
            }));
        }
        catch (IOException ex) {
            throw DefaultBigQueryRpc.translate(ex);
        }
    }

    @Override
    public boolean cancel(String jobId) throws BigQueryException {
        try {
            this.bigquery.jobs().cancel(this.options.projectId(), jobId).execute();
            return true;
        }
        catch (IOException ex) {
            BigQueryException serviceException = DefaultBigQueryRpc.translate(ex);
            if (serviceException.code() == 404) {
                return false;
            }
            throw serviceException;
        }
    }

    @Override
    public GetQueryResultsResponse getQueryResults(String jobId, Map<BigQueryRpc.Option, ?> options) throws BigQueryException {
        try {
            return (GetQueryResultsResponse)this.bigquery.jobs().getQueryResults(this.options.projectId(), jobId).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options)).setStartIndex(BigQueryRpc.Option.START_INDEX.getLong(options) != null ? BigInteger.valueOf(BigQueryRpc.Option.START_INDEX.getLong(options)) : null).setTimeoutMs(BigQueryRpc.Option.TIMEOUT.getLong(options)).execute();
        }
        catch (IOException ex) {
            BigQueryException serviceException = DefaultBigQueryRpc.translate(ex);
            if (serviceException.code() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    @Override
    public QueryResponse query(QueryRequest request) throws BigQueryException {
        try {
            return (QueryResponse)this.bigquery.jobs().query(this.options.projectId(), request).execute();
        }
        catch (IOException ex) {
            throw DefaultBigQueryRpc.translate(ex);
        }
    }

    @Override
    public String open(JobConfigurationLoad configuration) throws BigQueryException {
        try {
            Job loadJob = new Job().setConfiguration(new JobConfiguration().setLoad(configuration));
            StringBuilder builder = new StringBuilder().append(BASE_RESUMABLE_URI).append(this.options.projectId()).append("/jobs");
            GenericUrl url = new GenericUrl(builder.toString());
            url.set("uploadType", (Object)"resumable");
            JsonFactory jsonFactory = this.bigquery.getJsonFactory();
            HttpRequestFactory requestFactory = this.bigquery.getRequestFactory();
            HttpRequest httpRequest = requestFactory.buildPostRequest(url, (HttpContent)new JsonHttpContent(jsonFactory, (Object)loadJob));
            httpRequest.getHeaders().set("X-Upload-Content-Value", (Object)"application/octet-stream");
            HttpResponse response = httpRequest.execute();
            return response.getHeaders().getLocation();
        }
        catch (IOException ex) {
            throw DefaultBigQueryRpc.translate(ex);
        }
    }

    @Override
    public void write(String uploadId, byte[] toWrite, int toWriteOffset, long destOffset, int length, boolean last) throws BigQueryException {
        try {
            String message;
            int code;
            GenericUrl url = new GenericUrl(uploadId);
            HttpRequest httpRequest = this.bigquery.getRequestFactory().buildPutRequest(url, (HttpContent)new ByteArrayContent(null, toWrite, toWriteOffset, length));
            long limit = destOffset + (long)length;
            StringBuilder range = new StringBuilder("bytes ");
            range.append(destOffset).append('-').append(limit - 1L).append('/');
            if (last) {
                range.append(limit);
            } else {
                range.append('*');
            }
            httpRequest.getHeaders().setContentRange(range.toString());
            HttpResponseException exception = null;
            try {
                HttpResponse response = httpRequest.execute();
                code = response.getStatusCode();
                message = response.getStatusMessage();
            }
            catch (HttpResponseException ex) {
                exception = ex;
                code = ex.getStatusCode();
                message = ex.getStatusMessage();
            }
            if (!last && code != 308 || last && code != 200 && code != 201) {
                if (exception != null) {
                    throw exception;
                }
                throw new BigQueryException(code, message);
            }
        }
        catch (IOException ex) {
            throw DefaultBigQueryRpc.translate(ex);
        }
    }
}

