/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.base.Preconditions;
import com.google.gcloud.datastore.Serializable;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.format.ISODateTimeFormat;

public final class DateTime
extends Serializable<DatastoreV1.Value>
implements Comparable<DateTime> {
    private static final long serialVersionUID = 7343324797621228378L;
    private final transient long timestampMicroseconds;

    DateTime(long timestampMicroseconds) {
        this.timestampMicroseconds = timestampMicroseconds;
    }

    @Override
    public String toString() {
        return ISODateTimeFormat.dateTime().print(this.timestampMillis());
    }

    public int hashCode() {
        return (int)this.timestampMicroseconds;
    }

    @Override
    public int compareTo(DateTime other) {
        return this.toDate().compareTo(other.toDate());
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof DateTime && this.timestampMicroseconds == ((DateTime)obj).timestampMicroseconds;
    }

    public long timestampMicroseconds() {
        return this.timestampMicroseconds;
    }

    public long timestampMillis() {
        return this.timestampMicroseconds / 1000L;
    }

    public Date toDate() {
        return new Date(this.timestampMillis());
    }

    public Calendar toCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.timestampMillis());
        return cal;
    }

    public static DateTime now() {
        return DateTime.copyFrom(new Date());
    }

    public static DateTime copyFrom(Date date) {
        return new DateTime(((Date)Preconditions.checkNotNull((Object)date)).getTime() * 1000L);
    }

    public static DateTime copyFrom(Calendar calendar) {
        return DateTime.copyFrom(calendar.getTime());
    }

    @Override
    DatastoreV1.Value toPb() {
        return DatastoreV1.Value.newBuilder().setIntegerValue(this.timestampMicroseconds).build();
    }

    @Override
    Object fromPb(byte[] bytesPb) throws InvalidProtocolBufferException {
        return new DateTime(DatastoreV1.Value.parseFrom((byte[])bytesPb).getIntegerValue());
    }
}

