/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.gcloud.datastore.DateTime;
import com.google.gcloud.datastore.Value;
import com.google.gcloud.datastore.ValueType;

public final class DateTimeValue
extends Value<DateTime> {
    private static final long serialVersionUID = -5096238337676649540L;
    static final Value.BaseMarshaller<DateTime, DateTimeValue, Builder> MARSHALLER = new Value.BaseMarshaller<DateTime, DateTimeValue, Builder>(){
        private static final long serialVersionUID = -5695812592049332840L;

        @Override
        public int getProtoFieldId() {
            return 4;
        }

        @Override
        public Builder newBuilder(DateTime value) {
            return DateTimeValue.builder(value);
        }

        @Override
        protected DateTime getValue(DatastoreV1.Value from) {
            return new DateTime(from.getTimestampMicrosecondsValue());
        }

        @Override
        protected void setValue(DateTimeValue from, DatastoreV1.Value.Builder to) {
            to.setTimestampMicrosecondsValue(((DateTime)from.get()).timestampMicroseconds());
        }
    };

    public DateTimeValue(DateTime dateTime) {
        this(DateTimeValue.builder(dateTime));
    }

    private DateTimeValue(Builder builder) {
        super(builder);
    }

    public Builder toBuilder() {
        return (Builder)new Builder().mergeFrom(this);
    }

    public static DateTimeValue of(DateTime dateTime) {
        return new DateTimeValue(dateTime);
    }

    public static Builder builder(DateTime dateTime) {
        return (Builder)new Builder().set(dateTime);
    }

    public static final class Builder
    extends Value.BaseBuilder<DateTime, DateTimeValue, Builder> {
        private Builder() {
            super(ValueType.DATE_TIME);
        }

        @Override
        public DateTimeValue build() {
            return new DateTimeValue(this);
        }
    }
}

