/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.base.Preconditions;
import com.google.gcloud.datastore.FullEntity;
import com.google.gcloud.datastore.Value;
import com.google.gcloud.datastore.ValueType;

public class EntityValue
extends Value<FullEntity<?>> {
    private static final long serialVersionUID = -5461475706792576395L;
    static final Value.BaseMarshaller<FullEntity<?>, EntityValue, Builder> MARSHALLER = new Value.BaseMarshaller<FullEntity<?>, EntityValue, Builder>(){
        private static final long serialVersionUID = 2355075086076070931L;

        @Override
        public int getProtoFieldId() {
            return 6;
        }

        @Override
        public Builder newBuilder(FullEntity<?> value) {
            return EntityValue.builder(value);
        }

        @Override
        protected FullEntity<?> getValue(DatastoreV1.Value from) {
            return FullEntity.fromPb(from.getEntityValue());
        }

        @Override
        protected void setValue(EntityValue from, DatastoreV1.Value.Builder to) {
            to.setEntityValue(((FullEntity)from.get()).toPb());
        }
    };

    public EntityValue(FullEntity<?> entity) {
        this(EntityValue.builder(entity));
    }

    private EntityValue(Builder builder) {
        super(builder);
    }

    public Builder toBuilder() {
        return (Builder)new Builder().mergeFrom(this);
    }

    public static EntityValue of(FullEntity<?> entity) {
        return new EntityValue(entity);
    }

    public static Builder builder(FullEntity<?> entity) {
        return ((Builder)new Builder().set(entity)).indexed(false);
    }

    public static final class Builder
    extends Value.BaseBuilder<FullEntity<?>, EntityValue, Builder> {
        private Builder() {
            super(ValueType.ENTITY);
        }

        @Override
        public Builder indexed(boolean indexed) {
            Preconditions.checkArgument((!indexed ? 1 : 0) != 0, (Object)"EntityValue can't be indexed");
            return (Builder)super.indexed(indexed);
        }

        @Override
        public EntityValue build() {
            return new EntityValue(this);
        }
    }
}

