/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gcloud.datastore.BaseKey;
import com.google.gcloud.datastore.Key;
import com.google.gcloud.datastore.PathElement;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;

public class IncompleteKey
extends BaseKey {
    private static final long serialVersionUID = -75301206578793347L;

    IncompleteKey(String projectId, String namespace, ImmutableList<PathElement> path) {
        super(projectId, namespace, path);
    }

    @Override
    Object fromPb(byte[] bytesPb) throws InvalidProtocolBufferException {
        return IncompleteKey.fromPb(DatastoreV1.Key.parseFrom((byte[])bytesPb));
    }

    static IncompleteKey fromPb(DatastoreV1.Key keyPb) {
        List pathElementsPb;
        String projectId = null;
        String namespace = null;
        if (keyPb.hasPartitionId()) {
            DatastoreV1.PartitionId partitionIdPb = keyPb.getPartitionId();
            if (partitionIdPb.hasDatasetId()) {
                projectId = partitionIdPb.getDatasetId();
            }
            if (partitionIdPb.hasNamespace()) {
                namespace = partitionIdPb.getNamespace();
            }
        }
        Preconditions.checkArgument((!(pathElementsPb = keyPb.getPathElementList()).isEmpty() ? 1 : 0) != 0, (Object)"Path must not be empty");
        ImmutableList.Builder pathBuilder = ImmutableList.builder();
        for (DatastoreV1.Key.PathElement pathElementPb : pathElementsPb) {
            pathBuilder.add((Object)PathElement.fromPb(pathElementPb));
        }
        ImmutableList path = pathBuilder.build();
        PathElement leaf = (PathElement)path.get(path.size() - 1);
        if (leaf.nameOrId() != null) {
            return new Key(projectId, namespace, (ImmutableList<PathElement>)path);
        }
        return new IncompleteKey(projectId, namespace, (ImmutableList<PathElement>)path);
    }

    public static Builder builder(String projectId, String kind) {
        return new Builder(projectId, kind);
    }

    public static Builder builder(IncompleteKey copyFrom) {
        return new Builder(copyFrom);
    }

    public static Builder builder(Key parent, String kind) {
        return (Builder)((Builder)IncompleteKey.builder(parent.projectId(), kind).namespace(parent.namespace())).ancestors(parent.path());
    }

    public static class Builder
    extends BaseKey.Builder<Builder> {
        private Builder(String projectId, String kind) {
            super(projectId, kind);
        }

        private Builder(IncompleteKey copyFrom) {
            super(copyFrom);
        }

        @Override
        public IncompleteKey build() {
            ImmutableList path = ImmutableList.builder().addAll((Iterable)this.ancestors).add((Object)PathElement.of(this.kind)).build();
            return new IncompleteKey(this.projectId, this.namespace, (ImmutableList<PathElement>)path);
        }
    }
}

