/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gcloud.datastore.DatastoreException;
import com.google.gcloud.datastore.Value;
import com.google.gcloud.datastore.ValueType;
import java.util.ArrayList;
import java.util.List;

public final class ListValue
extends Value<List<? extends Value<?>>> {
    private static final long serialVersionUID = -5461475706792576395L;
    static final Value.BaseMarshaller<List<? extends Value<?>>, ListValue, Builder> MARSHALLER = new Value.BaseMarshaller<List<? extends Value<?>>, ListValue, Builder>(){
        private static final long serialVersionUID = -3193794036327640106L;

        @Override
        public int getProtoFieldId() {
            return 7;
        }

        @Override
        public Builder newBuilder(List<? extends Value<?>> values) {
            return ListValue.builder().set(values);
        }

        @Override
        protected List<Value<?>> getValue(DatastoreV1.Value from) {
            ArrayList properties = new ArrayList(from.getListValueCount());
            for (DatastoreV1.Value valuePb : from.getListValueList()) {
                properties.add(Value.fromPb(valuePb));
            }
            return properties;
        }

        @Override
        protected void setValue(ListValue from, DatastoreV1.Value.Builder to) {
            for (Value property : (List)from.get()) {
                to.addListValue(property.toPb());
            }
        }
    };

    public ListValue(List<? extends Value<?>> values) {
        this(ListValue.builder().set(values));
    }

    public ListValue(Value<?> first, Value<?> ... other) {
        this(new Builder().addValue(first, other));
    }

    private ListValue(Builder builder) {
        super(builder);
    }

    public Builder toBuilder() {
        return (Builder)new Builder().mergeFrom(this);
    }

    public static ListValue of(List<? extends Value<?>> values) {
        return new ListValue(values);
    }

    public static ListValue of(Value<?> first, Value<?> ... other) {
        return new ListValue(first, other);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends Value.BaseBuilder<List<? extends Value<?>>, ListValue, Builder> {
        private ImmutableList.Builder<Value<?>> listBuilder = ImmutableList.builder();

        private Builder() {
            super(ValueType.LIST);
        }

        public Builder addValue(Value<?> value) {
            Preconditions.checkArgument((value.type() != ValueType.LIST ? 1 : 0) != 0, (Object)"Cannot contain another list");
            this.listBuilder.add(value);
            return this;
        }

        public Builder addValue(Value<?> first, Value<?> ... other) {
            this.addValue(first);
            for (Value<?> value : other) {
                this.addValue(value);
            }
            return this;
        }

        @Override
        public Builder indexed(boolean indexed) {
            throw DatastoreException.throwInvalidRequest("ListValue can't specify index", new Object[0]);
        }

        @Override
        public Builder set(List<? extends Value<?>> values) {
            this.listBuilder = ImmutableList.builder();
            for (Value<?> value : values) {
                this.addValue(value);
            }
            return this;
        }

        @Override
        public List<? extends Value<?>> get() {
            return this.listBuilder.build();
        }

        @Override
        public ListValue build() {
            Preconditions.checkState((!this.get().isEmpty() ? 1 : 0) != 0, (Object)"value list could not be empty");
            return new ListValue(this);
        }
    }
}

